/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.ImplicitFunction;
import jscl.math.operator.Operator;
import jscl.math.operator.PolynomialVector;
import jscl.math.polynomial.Basis;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;

public class Groebner
extends Operator {
    public static final Generic lex = new Constant("lex").expressionValue();
    public static final Generic tdl = new Constant("tdl").expressionValue();
    public static final Generic drl = new Constant("drl").expressionValue();
    public static final ImplicitFunction.Curried elim = ImplicitFunction.apply("elim", new int[1]);

    public Groebner(Generic generic, Generic generic2, Generic generic3, Generic generic4) {
        super("groebner", new Generic[]{generic, generic2, generic3, generic4});
    }

    @Override
    public Generic compute() {
        Generic[] genericArray = this.parameter[0].expand().vectorValue().elements();
        Variable[] variableArray = Groebner.variables(this.parameter[1].vectorValue());
        Ordering ordering = Groebner.ordering(this.parameter[2]);
        int n = this.parameter[3].integerValue().intValue();
        return new PolynomialVector(Basis.compute(genericArray, variableArray, ordering, n));
    }

    static Ordering ordering(Generic generic) {
        Variable variable = generic.variableValue();
        if (variable.compareTo(lex.variableValue()) == 0) {
            return Monomial.lexicographic;
        }
        if (variable.compareTo(tdl.variableValue()) == 0) {
            return Monomial.totalDegreeLexicographic;
        }
        if (variable.compareTo(drl.variableValue()) == 0) {
            return Monomial.degreeReverseLexicographic;
        }
        if (variable instanceof ImplicitFunction) {
            Generic[] genericArray = ((ImplicitFunction)variable).parameters();
            int n = genericArray[0].integerValue().intValue();
            if (variable.compareTo(elim.apply(new Generic[]{JSCLInteger.valueOf(n)}).variableValue()) == 0) {
                return Monomial.kthElimination(n);
            }
        }
        throw new ArithmeticException();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 4;
        if (this.parameter[3].signum() == 0) {
            n = 3;
            if (Groebner.ordering(this.parameter[2]) == Monomial.lexicographic) {
                n = 2;
            }
        }
        stringBuffer.append(this.name);
        stringBuffer.append("(");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < n - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 4;
        if (this.parameter[3].signum() == 0) {
            n = 3;
            if (Groebner.ordering(this.parameter[2]) == Monomial.lexicographic) {
                n = 2;
            }
        }
        stringBuffer.append("<apply>");
        stringBuffer.append("<ci>" + this.nameToMathML() + "</ci>");
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(this.parameter[i].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Groebner(null, null, null, null);
    }
}

