/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotVariableException;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Pow;
import jscl.math.operator.Operator;
import jscl.util.ArrayComparator;

public class Factorial
extends Operator {
    public Factorial(Generic generic, Generic generic2) {
        super("", new Generic[]{generic, generic2});
    }

    public Factorial(Generic generic) {
        this(generic, JSCLInteger.valueOf(1L));
    }

    @Override
    public Generic compute() {
        int n = this.parameter[1].integerValue().intValue();
        try {
            return this.parameter[0].integerValue().factorial(n);
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Factorial factorial = (Factorial)variable;
        return ArrayComparator.comparator.compare(this.parameter, factorial.parameter);
    }

    @Override
    public String toString() {
        int n = this.parameter[1].integerValue().intValue();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            JSCLInteger jSCLInteger = this.parameter[0].integerValue();
            stringBuffer.append(jSCLInteger);
        }
        catch (NotIntegerException notIntegerException) {
            try {
                Variable variable = this.parameter[0].variableValue();
                if (variable instanceof Frac || variable instanceof Pow) {
                    stringBuffer.append("(").append(this.parameter[0]).append(")");
                } else {
                    stringBuffer.append(variable);
                }
            }
            catch (NotVariableException notVariableException) {
                stringBuffer.append("(").append(this.parameter[0]).append(")");
            }
        }
        for (int i = 0; i < n; ++i) {
            stringBuffer.append("!");
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        int n = this.parameter[1].integerValue().intValue();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply><factorial/>");
        stringBuffer.append(this.parameter[0].toMathML());
        if (n > 1) {
            stringBuffer.append(JSCLInteger.valueOf(n).toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Factorial(null, null);
    }
}

