/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.math.numeric.NumericMatrix;
import jscl.util.ArrayComparator;

public class NumericVector
extends Numeric {
    protected final Numeric[] element;
    protected final int n;

    public NumericVector(Numeric[] numericArray) {
        this.element = numericArray;
        this.n = numericArray.length;
    }

    public Numeric[] elements() {
        return this.element;
    }

    public NumericVector add(NumericVector numericVector) {
        NumericVector numericVector2 = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            numericVector2.element[i] = this.element[i].add(numericVector.element[i]);
        }
        return numericVector2;
    }

    @Override
    public Numeric add(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.add((NumericVector)numeric);
        }
        return this.add(this.valueof(numeric));
    }

    public NumericVector subtract(NumericVector numericVector) {
        NumericVector numericVector2 = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            numericVector2.element[i] = this.element[i].subtract(numericVector.element[i]);
        }
        return numericVector2;
    }

    @Override
    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.subtract((NumericVector)numeric);
        }
        return this.subtract(this.valueof(numeric));
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.scalarProduct((NumericVector)numeric);
        }
        if (numeric instanceof NumericMatrix) {
            return ((NumericMatrix)numeric).transpose().multiply(this);
        }
        NumericVector numericVector = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            numericVector.element[i] = this.element[i].multiply(numeric);
        }
        return numericVector;
    }

    @Override
    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof NumericVector) {
            throw new ArithmeticException();
        }
        if (numeric instanceof NumericMatrix) {
            return this.multiply(((NumericMatrix)numeric).inverse());
        }
        NumericVector numericVector = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            numericVector.element[i] = this.element[i].divide(numeric);
        }
        return numericVector;
    }

    @Override
    public Numeric negate() {
        NumericVector numericVector = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            numericVector.element[i] = this.element[i].negate();
        }
        return numericVector;
    }

    @Override
    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            int n = this.element[i].signum();
            if (n < 0) {
                return -1;
            }
            if (n <= 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof NumericVector || numeric instanceof NumericMatrix) {
            throw new ArithmeticException();
        }
        NumericVector numericVector = (NumericVector)NumericVector.unity(this.n).multiply(numeric);
        return this.newinstance(numericVector.element);
    }

    public Numeric magnitude2() {
        return this.scalarProduct(this);
    }

    public Numeric scalarProduct(NumericVector numericVector) {
        Numeric numeric = JSCLDouble.valueOf(0.0);
        for (int i = 0; i < this.n; ++i) {
            numeric = ((Numeric)numeric).add(this.element[i].multiply(numericVector.element[i]));
        }
        return numeric;
    }

    @Override
    public Numeric log() {
        throw new ArithmeticException();
    }

    @Override
    public Numeric exp() {
        throw new ArithmeticException();
    }

    @Override
    public Numeric conjugate() {
        NumericVector numericVector = this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            numericVector.element[i] = this.element[i].conjugate();
        }
        return numericVector;
    }

    public int compareTo(NumericVector numericVector) {
        return ArrayComparator.comparator.compare(this.element, numericVector.element);
    }

    @Override
    public int compareTo(Numeric numeric) {
        if (numeric instanceof NumericVector) {
            return this.compareTo((NumericVector)numeric);
        }
        return this.compareTo(this.valueof(numeric));
    }

    public static NumericVector unity(int n) {
        NumericVector numericVector = new NumericVector(new Numeric[n]);
        for (int i = 0; i < numericVector.n; ++i) {
            numericVector.element[i] = i == 0 ? JSCLDouble.valueOf(1.0) : JSCLDouble.valueOf(0.0);
        }
        return numericVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append(this.element[i]).append(i < this.n - 1 ? ", " : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<vector>");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append(this.element[i].toMathML());
        }
        stringBuffer.append("</vector>");
        return stringBuffer.toString();
    }

    protected NumericVector newinstance() {
        return this.newinstance(new Numeric[this.n]);
    }

    protected NumericVector newinstance(Numeric[] numericArray) {
        return new NumericVector(numericArray);
    }
}

