/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.Complex;
import jscl.math.numeric.Numeric;

public final class JSCLDouble
extends Numeric {
    double content;

    JSCLDouble(double d) {
        this.content = d;
    }

    public JSCLDouble add(JSCLDouble jSCLDouble) {
        return new JSCLDouble(this.content + jSCLDouble.content);
    }

    @Override
    public Numeric add(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.add((JSCLDouble)numeric);
        }
        return numeric.valueof(this).add(numeric);
    }

    public JSCLDouble subtract(JSCLDouble jSCLDouble) {
        return new JSCLDouble(this.content - jSCLDouble.content);
    }

    @Override
    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.subtract((JSCLDouble)numeric);
        }
        return numeric.valueof(this).subtract(numeric);
    }

    public JSCLDouble multiply(JSCLDouble jSCLDouble) {
        return new JSCLDouble(this.content * jSCLDouble.content);
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.multiply((JSCLDouble)numeric);
        }
        return numeric.multiply(this);
    }

    public JSCLDouble divide(JSCLDouble jSCLDouble) throws ArithmeticException {
        return new JSCLDouble(this.content / jSCLDouble.content);
    }

    @Override
    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof JSCLDouble) {
            return this.divide((JSCLDouble)numeric);
        }
        return numeric.valueof(this).divide(numeric);
    }

    @Override
    public Numeric negate() {
        return new JSCLDouble(-this.content);
    }

    @Override
    public int signum() {
        return this.content == 0.0 ? 0 : (this.content < 0.0 ? -1 : 1);
    }

    @Override
    public Numeric log() {
        return new JSCLDouble(Math.log(this.content));
    }

    @Override
    public Numeric exp() {
        return new JSCLDouble(Math.exp(this.content));
    }

    @Override
    public Numeric inverse() {
        return new JSCLDouble(1.0 / this.content);
    }

    public Numeric pow(JSCLDouble jSCLDouble) {
        if (this.signum() < 0) {
            return Complex.valueOf(this.content, 0.0).pow(jSCLDouble);
        }
        return new JSCLDouble(Math.pow(this.content, jSCLDouble.content));
    }

    @Override
    public Numeric pow(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.pow((JSCLDouble)numeric);
        }
        return numeric.valueof(this).pow(numeric);
    }

    @Override
    public Numeric sqrt() {
        if (this.signum() < 0) {
            return Complex.valueOf(0.0, 1.0).multiply(this.negate().sqrt());
        }
        return new JSCLDouble(Math.sqrt(this.content));
    }

    @Override
    public Numeric nthrt(int n) {
        if (this.signum() < 0) {
            return n % 2 == 0 ? this.sqrt().nthrt(n / 2) : this.negate().nthrt(n).negate();
        }
        return super.nthrt(n);
    }

    @Override
    public Numeric conjugate() {
        return this;
    }

    @Override
    public Numeric acos() {
        return new JSCLDouble(Math.acos(this.content));
    }

    @Override
    public Numeric asin() {
        return new JSCLDouble(Math.asin(this.content));
    }

    @Override
    public Numeric atan() {
        return new JSCLDouble(Math.atan(this.content));
    }

    @Override
    public Numeric cos() {
        return new JSCLDouble(Math.cos(this.content));
    }

    @Override
    public Numeric sin() {
        return new JSCLDouble(Math.sin(this.content));
    }

    @Override
    public Numeric tan() {
        return new JSCLDouble(Math.tan(this.content));
    }

    public JSCLDouble valueof(JSCLDouble jSCLDouble) {
        return new JSCLDouble(jSCLDouble.content);
    }

    @Override
    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.valueof((JSCLDouble)numeric);
        }
        throw new ArithmeticException();
    }

    public double doubleValue() {
        return this.content;
    }

    public int compareTo(JSCLDouble jSCLDouble) {
        if (this.content < jSCLDouble.content) {
            return -1;
        }
        if (this.content > jSCLDouble.content) {
            return 1;
        }
        if (this.content == jSCLDouble.content) {
            return 0;
        }
        throw new ArithmeticException();
    }

    @Override
    public int compareTo(Numeric numeric) {
        if (numeric instanceof JSCLDouble) {
            return this.compareTo((JSCLDouble)numeric);
        }
        return numeric.valueof(this).compareTo(numeric);
    }

    public static JSCLDouble valueOf(double d) {
        return new JSCLDouble(d);
    }

    public String toString() {
        return String.valueOf(this.content);
    }

    public String toMathML() {
        return "<cn type=\"real\">" + this.content + "</cn>";
    }
}

