/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.hyperbolic;

import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Exp;
import jscl.math.function.Trigonometric;
import jscl.math.function.hyperbolic.Asinh;
import jscl.math.function.hyperbolic.Cosh;

public class Sinh
extends Trigonometric {
    public Sinh(Generic generic) {
        super("sinh", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Cosh(this.parameter[0]).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return new Cosh(this.parameter[0]).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Sinh(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Exp(this.parameter[0]).evalelem().subtract(new Exp(this.parameter[0].negate()).evalelem()).multiply(Constant.half);
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Sinh(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            Variable variable = this.parameter[0].variableValue();
            if (variable instanceof Asinh) {
                Generic[] genericArray = ((Asinh)variable).parameters();
                return genericArray[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic generic, Generic generic2) {
        return new Cosh(generic2).evalsimp().multiply(new Sinh(generic).evalsimp()).add(new Cosh(generic).evalsimp().multiply(new Sinh(generic2).evalsimp()));
    }

    @Override
    public Generic evalfunc() {
        return ((Function)this.parameter[0]).sinh();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).sinh();
    }

    @Override
    protected Variable newinstance() {
        return new Sinh(null);
    }
}

