/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Antiderivative;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.TechnicalVariable;
import jscl.math.Variable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Cubic;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.function.Pow;
import jscl.math.function.Sigma;
import jscl.math.function.Sqrt;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;
import jscl.util.ArrayComparator;

public class Root
extends Algebraic {
    protected Generic subscript;

    public static Generic[] apply(Generic[] genericArray) {
        Generic[] genericArray2 = new Generic[genericArray.length - 1];
        for (int i = 0; i < genericArray2.length; ++i) {
            genericArray2[i] = new Root(genericArray, i).expressionValue();
        }
        return genericArray2;
    }

    public Root(Generic[] genericArray, Generic generic) {
        super("root", genericArray);
        this.subscript = generic;
    }

    public Root(Generic[] genericArray, int n) {
        this(genericArray, JSCLInteger.valueOf(n));
    }

    public Root(UnivariatePolynomial univariatePolynomial, int n) {
        this(univariatePolynomial.normalize().elements(), n);
    }

    public Generic subscript() {
        return this.subscript;
    }

    @Override
    public Root rootValue() {
        return this;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        boolean bl = true;
        for (int i = 0; i < this.parameter.length; ++i) {
            bl = bl && this.parameter[i].isPolynomial(variable);
        }
        if (bl) {
            return Antiderivative.compute(this, variable);
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.compareTo(variable) == 0) {
            return JSCLInteger.valueOf(1L);
        }
        TechnicalVariable technicalVariable = new TechnicalVariable("t");
        Generic[] genericArray = new Generic[this.parameter.length];
        for (int i = 0; i < this.parameter.length; ++i) {
            genericArray[i] = this.parameter[i].derivative(variable);
        }
        UnivariatePolynomial univariatePolynomial = (UnivariatePolynomial)Polynomial.factory(this);
        UnivariatePolynomial univariatePolynomial2 = univariatePolynomial.valueof(this.parameter);
        UnivariatePolynomial univariatePolynomial3 = (UnivariatePolynomial)univariatePolynomial2.derivative().multiply(technicalVariable.expressionValue()).add(univariatePolynomial.valueof(genericArray));
        UnivariatePolynomial univariatePolynomial4 = (UnivariatePolynomial)Polynomial.factory(technicalVariable).valueof(univariatePolynomial2.resultant(univariatePolynomial3));
        return new Root(univariatePolynomial4.elements(), this.subscript).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return null;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].substitute(variable, generic);
        }
        root.subscript = this.subscript.substitute(variable, generic);
        if (root.isIdentity(variable)) {
            return generic;
        }
        return root.evaluate();
    }

    @Override
    public Generic eval() {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].eval();
        }
        root.subscript = this.subscript.eval();
        return root.evaluate();
    }

    @Override
    public Generic expand() {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].expand();
        }
        root.subscript = this.subscript.expand();
        return root.expressionValue();
    }

    @Override
    public Generic factorize() {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].factorize();
        }
        root.subscript = this.subscript;
        return root.expressionValue();
    }

    @Override
    public Generic elementary() {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].elementary();
        }
        root.subscript = this.subscript.elementary();
        return root.evalelem();
    }

    @Override
    public Generic simplify() {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].simplify();
        }
        root.subscript = this.subscript.simplify();
        return root.evalsimp();
    }

    @Override
    public Generic numeric() {
        Root root = (Root)this.newinstance();
        for (int i = 0; i < this.parameter.length; ++i) {
            root.parameter[i] = this.parameter[i].numeric();
        }
        root.subscript = this.subscript;
        return root.evalnum();
    }

    @Override
    public Generic evaluate() {
        if (this.isZero()) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            int n = this.subscript.integerValue().intValue();
            switch (this.degree()) {
                case 1: {
                    return new Frac(this.parameter[0], this.parameter[1]).evaluate().negate();
                }
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        if (this.isZero()) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            int n = this.subscript.integerValue().intValue();
            switch (this.degree()) {
                case 1: {
                    return Root.linear(this.parameter);
                }
                case 2: {
                    return Root.quadratic(this.parameter, n);
                }
                case 3: {
                    return Root.cubic(this.parameter, n);
                }
                case 4: {
                    return Root.quartic(this.parameter, n);
                }
            }
            if (this.isNth() && n == 0) {
                return Root.nth(this.parameter);
            }
        }
        catch (NotIntegerException notIntegerException) {
            // empty catch block
        }
        return this.expressionValue();
    }

    boolean isZero() {
        boolean bl = this.degree() > 0;
        for (int i = 0; i < this.degree(); ++i) {
            bl = bl && this.parameter[i].signum() == 0;
        }
        bl = bl && this.parameter[this.degree()].signum() != 0;
        return bl;
    }

    boolean isNth() {
        boolean bl = this.degree() > 0;
        for (int i = 1; i < this.degree(); ++i) {
            bl = bl && this.parameter[i].signum() == 0;
        }
        bl = bl && this.parameter[this.degree()].signum() != 0;
        return bl;
    }

    static Generic nth(Generic[] genericArray) {
        int n = genericArray.length - 1;
        Generic generic = new Frac(genericArray[0], genericArray[n]).evalsimp();
        return new Pow(generic.negate(), new Inv(JSCLInteger.valueOf(n)).evalsimp()).evalsimp();
    }

    static Generic linear(Generic[] genericArray) {
        Generic generic = new Frac(genericArray[0], genericArray[1]).evalsimp();
        return generic.negate();
    }

    static Generic quadratic(Generic[] genericArray, int n) {
        Generic generic = new Frac(genericArray[1], genericArray[2]).evalsimp();
        Generic generic2 = new Frac(genericArray[0], genericArray[2]).evalsimp();
        Generic generic3 = new Sqrt(generic.pow(2).subtract(JSCLInteger.valueOf(4L).multiply(generic2))).evalsimp();
        switch (n) {
            case 0: {
                return new Frac(generic.subtract(generic3), JSCLInteger.valueOf(2L)).evalsimp().negate();
            }
        }
        return new Frac(generic.add(generic3), JSCLInteger.valueOf(2L)).evalsimp().negate();
    }

    static Generic cubic(Generic[] genericArray, int n) {
        Generic generic = new Frac(genericArray[2], genericArray[3]).evalsimp();
        Generic generic2 = new Frac(genericArray[1], genericArray[3]).evalsimp();
        Generic generic3 = new Frac(genericArray[0], genericArray[3]).evalsimp();
        Generic[] genericArray2 = new Generic[2];
        for (int i = 0; i < genericArray2.length; ++i) {
            genericArray2[i] = new Cubic(new Root(new Generic[]{generic.pow(6).subtract(JSCLInteger.valueOf(9L).multiply(generic.pow(4)).multiply(generic2)).add(JSCLInteger.valueOf(27L).multiply(generic.pow(2)).multiply(generic2.pow(2))).subtract(JSCLInteger.valueOf(27L).multiply(generic2.pow(3))), JSCLInteger.valueOf(2L).multiply(generic.pow(3)).subtract(JSCLInteger.valueOf(9L).multiply(generic).multiply(generic2)).add(JSCLInteger.valueOf(27L).multiply(generic3)), JSCLInteger.valueOf(1L)}, i).evalsimp()).evalsimp();
        }
        switch (n) {
            case 0: {
                return new Frac(generic.subtract(genericArray2[0]).subtract(genericArray2[1]), JSCLInteger.valueOf(3L)).evalsimp().negate();
            }
            case 1: {
                return new Frac(generic.subtract(Constant.j.multiply(genericArray2[0])).subtract(Constant.jbar.multiply(genericArray2[1])), JSCLInteger.valueOf(3L)).evalsimp().negate();
            }
        }
        return new Frac(generic.subtract(Constant.jbar.multiply(genericArray2[0])).subtract(Constant.j.multiply(genericArray2[1])), JSCLInteger.valueOf(3L)).evalsimp().negate();
    }

    static Generic quartic(Generic[] genericArray, int n) {
        Generic generic = new Frac(genericArray[3], genericArray[4]).evalsimp();
        Generic generic2 = new Frac(genericArray[2], genericArray[4]).evalsimp();
        Generic generic3 = new Frac(genericArray[1], genericArray[4]).evalsimp();
        Generic generic4 = new Frac(genericArray[0], genericArray[4]).evalsimp();
        Generic[] genericArray2 = new Generic[3];
        for (int i = 0; i < genericArray2.length; ++i) {
            genericArray2[i] = new Sqrt(new Root(new Generic[]{generic.pow(6).subtract(JSCLInteger.valueOf(8L).multiply(generic.pow(4)).multiply(generic2)).add(JSCLInteger.valueOf(16L).multiply(generic.pow(2)).multiply(generic2.pow(2))).add(JSCLInteger.valueOf(16L).multiply(generic.pow(3)).multiply(generic3)).subtract(JSCLInteger.valueOf(64L).multiply(generic).multiply(generic2).multiply(generic3)).add(JSCLInteger.valueOf(64L).multiply(generic3.pow(2))), JSCLInteger.valueOf(-3L).multiply(generic.pow(4)).add(JSCLInteger.valueOf(16L).multiply(generic.pow(2)).multiply(generic2)).subtract(JSCLInteger.valueOf(16L).multiply(generic2.pow(2))).subtract(JSCLInteger.valueOf(16L).multiply(generic).multiply(generic3)).add(JSCLInteger.valueOf(64L).multiply(generic4)), JSCLInteger.valueOf(3L).multiply(generic.pow(2)).subtract(JSCLInteger.valueOf(8L).multiply(generic2)), JSCLInteger.valueOf(-1L)}, i).evalsimp()).evalsimp();
        }
        switch (n) {
            case 0: {
                return new Frac(generic.add(genericArray2[0]).subtract(genericArray2[1]).subtract(genericArray2[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
            }
            case 1: {
                return new Frac(generic.subtract(genericArray2[0]).subtract(genericArray2[1]).add(genericArray2[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
            }
            case 2: {
                return new Frac(generic.add(genericArray2[0]).add(genericArray2[1]).add(genericArray2[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
            }
        }
        return new Frac(generic.subtract(genericArray2[0]).add(genericArray2[1]).subtract(genericArray2[2]), JSCLInteger.valueOf(4L)).evalsimp().negate();
    }

    public int degree() {
        return this.parameter.length - 1;
    }

    @Override
    public Generic evalfunc() {
        return Function.root(this.subscript.integerValue().intValue(), this.parameter);
    }

    @Override
    public Generic evalnum() {
        return NumericWrapper.root(this.subscript.integerValue().intValue(), this.parameter);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        Root root = (Root)variable;
        n = ArrayComparator.comparator.compare(this.parameter, root.parameter);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return this.subscript.compareTo(root.subscript);
    }

    public static Generic sigma(Generic[] genericArray, int n) {
        Sigma sigma = new Sigma(genericArray, n);
        sigma.compute();
        return sigma.getValue();
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.name);
        stringBuffer.append("[").append(this.subscript).append("]");
        stringBuffer.append("(");
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i]).append(i < this.parameter.length - 1 ? ", " : "");
        }
        stringBuffer.append(")");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<apply>");
        stringBuffer.append(new Constant(this.name, 0, new Generic[]{this.subscript}).toMathML());
        for (int i = 0; i < this.parameter.length; ++i) {
            stringBuffer.append(this.parameter[i].toMathML());
        }
        stringBuffer.append("</apply>");
        return stringBuffer.toString();
    }

    @Override
    protected Variable newinstance() {
        return new Root(new Generic[this.parameter.length], null);
    }
}

