/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Inv;
import jscl.math.function.Sqrt;

public class Log
extends Function {
    public Log(Generic generic) {
        super("log", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(int n) {
        return new Inv(this.parameter[0]).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return JSCLInteger.valueOf(0L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        try {
            JSCLInteger jSCLInteger = this.parameter[0].integerValue();
            if (jSCLInteger.signum() < 0) {
                return Constant.i.multiply(Constant.pi).add(new Log(jSCLInteger.negate()).evalelem());
            }
            Generic generic = jSCLInteger.factorize();
            Generic[] genericArray = generic.productValue();
            Generic generic2 = JSCLInteger.valueOf(0L);
            for (int i = 0; i < genericArray.length; ++i) {
                Power power = genericArray[i].powerValue();
                generic2 = ((Generic)generic2).add(JSCLInteger.valueOf(power.exponent()).multiply(new Log(power.value()).expressionValue()));
            }
            return generic2;
        }
        catch (NotIntegerException notIntegerException) {
            Generic[] genericArray;
            try {
                genericArray = this.parameter[0].variableValue();
                if (genericArray instanceof Sqrt) {
                    Generic[] genericArray2 = ((Sqrt)genericArray).parameters();
                    return Constant.half.multiply(new Log(genericArray2[0]).evalelem());
                }
            }
            catch (NotVariableException notVariableException) {
                // empty catch block
            }
            genericArray = Frac.separateCoefficient(this.parameter[0]);
            if (genericArray[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || genericArray[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
                return new Log(genericArray[2]).evalelem().add(new Log(genericArray[0]).evalelem()).subtract(new Log(genericArray[1]).evalelem());
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalsimp() {
        return this.evaluate();
    }

    @Override
    public Generic evalfunc() {
        return ((jscl.math.Function)this.parameter[0]).log();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).log();
    }

    @Override
    public String toMathML() {
        return "<apply><ln/>" + this.parameter[0].toMathML() + "</apply>";
    }

    @Override
    protected Variable newinstance() {
        return new Log(null);
    }
}

