/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Inv;
import jscl.math.function.Log;
import jscl.math.function.Pow;
import jscl.math.polynomial.Polynomial;

public class Exp
extends Function {
    public Exp(Generic generic) {
        super("exp", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Generic generic = this.parameter[0];
        if (generic.isPolynomial(variable)) {
            Polynomial polynomial = Polynomial.factory(variable).valueof(generic);
            if (polynomial.degree() == 1) {
                Generic[] genericArray = polynomial.elements();
                return new Inv(genericArray[1]).evaluate().multiply(this.antiderivative(0));
            }
            throw new NotIntegrableException();
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return this.evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return this.evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() >= 0 && this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(1L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return this.evaluate();
    }

    @Override
    public Generic evalsimp() {
        Generic[] genericArray;
        block8: {
            if (this.parameter[0].signum() < 0) {
                return new Inv(new Exp(this.parameter[0].negate()).evalsimp()).evalsimp();
            }
            if (this.parameter[0].signum() == 0) {
                return JSCLInteger.valueOf(1L);
            }
            if (this.parameter[0].compareTo(Constant.i.multiply(Constant.pi)) == 0) {
                return JSCLInteger.valueOf(-1L);
            }
            try {
                genericArray = this.parameter[0].variableValue();
                if (genericArray instanceof Log) {
                    Generic[] genericArray2 = ((Log)genericArray).parameters();
                    return genericArray2[0];
                }
            }
            catch (NotVariableException notVariableException) {
                Generic[] genericArray3 = this.parameter[0].sumValue();
                if (genericArray3.length <= 1) break block8;
                Generic generic = JSCLInteger.valueOf(1L);
                for (int i = 0; i < genericArray3.length; ++i) {
                    generic = ((Generic)generic).multiply(new Exp(genericArray3[i]).evalsimp());
                }
                return generic;
            }
        }
        if ((genericArray = Frac.separateCoefficient(this.parameter[0]))[0].compareTo(JSCLInteger.valueOf(1L)) != 0 || genericArray[1].compareTo(JSCLInteger.valueOf(1L)) != 0) {
            return new Pow(new Exp(genericArray[2]).evalsimp(), new Frac(genericArray[0], genericArray[1]).evalsimp()).evalsimp();
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalfunc() {
        return ((jscl.math.Function)this.parameter[0]).exp();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).exp();
    }

    @Override
    public String toMathML() {
        if (this.parameter[0].compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return "<exponentiale/>";
        }
        return super.toMathML();
    }

    @Override
    protected Variable newinstance() {
        return new Exp(null);
    }
}

