/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.Sqrt;

public class Abs
extends Function {
    public Abs(Generic generic) {
        super("abs", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return Constant.half.multiply(this.parameter[0]).multiply(new Abs(this.parameter[0]).evaluate());
    }

    @Override
    public Generic derivative(int n) {
        return new Frac(this.parameter[0], this.expressionValue()).evaluate();
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Abs(this.parameter[0].negate()).evaluate();
        }
        try {
            return this.parameter[0].integerValue().abs();
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalelem() {
        return new Sqrt(this.parameter[0].pow(2)).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Abs(this.parameter[0].negate()).evalsimp();
        }
        try {
            return this.parameter[0].integerValue().abs();
        }
        catch (NotIntegerException notIntegerException) {
            try {
                Variable variable = this.parameter[0].variableValue();
                if (variable instanceof Abs) {
                    Function function = (Function)variable;
                    return function.evalsimp();
                }
            }
            catch (NotVariableException notVariableException) {
                // empty catch block
            }
            return this.expressionValue();
        }
    }

    @Override
    public Generic evalfunc() {
        return ((jscl.math.Function)this.parameter[0]).abs();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).abs();
    }

    @Override
    protected Variable newinstance() {
        return new Abs(null);
    }
}

