/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import jscl.editor.rendering.MathObject;
import jscl.math.DoubleVariable;
import jscl.math.Expression;
import jscl.math.ExpressionVariable;
import jscl.math.Generic;
import jscl.math.MatrixVariable;
import jscl.math.NotIntegrableException;
import jscl.math.TechnicalVariable;
import jscl.math.VectorVariable;
import jscl.math.function.Algebraic;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Function;
import jscl.math.function.ImplicitFunction;
import jscl.math.function.Root;
import jscl.math.function.Sqrt;
import jscl.math.operator.Factorial;
import jscl.math.operator.Operator;

public abstract class Variable
implements Comparable,
MathObject {
    protected final String name;
    private static final Map special = new HashMap();
    protected static final Comparator comparator;

    public Variable(String string) {
        this.name = string;
    }

    public abstract Generic antiderivative(Variable var1) throws NotIntegrableException;

    public abstract Generic derivative(Variable var1);

    public abstract Generic substitute(Variable var1, Generic var2);

    public abstract Generic function(Variable var1);

    public abstract Generic eval();

    public abstract Generic expand();

    public abstract Generic factorize();

    public abstract Generic elementary();

    public abstract Generic simplify();

    public abstract Generic numeric();

    public Expression expressionValue() {
        return Expression.valueOf(this);
    }

    public abstract boolean isConstant(Variable var1);

    public boolean isIdentity(Variable variable) {
        return this.compareTo(variable) == 0;
    }

    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int n = comparator.compare(this, variable);
        if (n < 0) {
            return -1;
        }
        if (n > 0) {
            return 1;
        }
        return this.variableCompareTo(variable);
    }

    public abstract int variableCompareTo(Variable var1);

    public int compareTo(Object object) {
        return this.compareTo((Variable)object);
    }

    public boolean equals(Object object) {
        if (object instanceof Variable) {
            return this.compareTo((Variable)object) == 0;
        }
        return false;
    }

    public String toString() {
        return this.name;
    }

    protected String nameToMathML() {
        return special.containsKey(this.name) ? (String)special.get(this.name) : this.name;
    }

    protected abstract Variable newinstance();

    private static int value(Variable variable) {
        int n;
        if (variable instanceof TechnicalVariable) {
            n = 0;
        } else if (variable instanceof DoubleVariable) {
            n = 1;
        } else if (variable instanceof Frac && ((Frac)variable).integer()) {
            n = 2;
        } else if (variable instanceof Sqrt && ((Sqrt)variable).imaginary()) {
            n = 3;
        } else if (variable instanceof Constant) {
            n = 4;
        } else if (variable instanceof Root) {
            n = 5;
        } else if (variable instanceof Algebraic) {
            n = 6;
        } else if (variable instanceof ImplicitFunction) {
            n = 7;
        } else if (variable instanceof Function) {
            n = 8;
        } else if (variable instanceof Factorial) {
            n = 9;
        } else if (variable instanceof Operator) {
            n = 10;
        } else if (variable instanceof ExpressionVariable) {
            n = 11;
        } else if (variable instanceof VectorVariable) {
            n = 12;
        } else if (variable instanceof MatrixVariable) {
            n = 13;
        } else {
            throw new ArithmeticException();
        }
        return n;
    }

    static {
        special.put("Alpha", "\u0391");
        special.put("Beta", "\u0392");
        special.put("Gamma", "\u0393");
        special.put("Delta", "\u0394");
        special.put("Epsilon", "\u0395");
        special.put("Zeta", "\u0396");
        special.put("Eta", "\u0397");
        special.put("Theta", "\u0398");
        special.put("Iota", "\u0399");
        special.put("Kappa", "\u039a");
        special.put("Lambda", "\u039b");
        special.put("Mu", "\u039c");
        special.put("Nu", "\u039d");
        special.put("Xi", "\u039e");
        special.put("Pi", "\u03a0");
        special.put("Rho", "\u03a1");
        special.put("Sigma", "\u03a3");
        special.put("Tau", "\u03a4");
        special.put("Upsilon", "\u03a5");
        special.put("Phi", "\u03a6");
        special.put("Chi", "\u03a7");
        special.put("Psi", "\u03a8");
        special.put("Omega", "\u03a9");
        special.put("alpha", "\u03b1");
        special.put("beta", "\u03b2");
        special.put("gamma", "\u03b3");
        special.put("delta", "\u03b4");
        special.put("epsilon", "\u03b5");
        special.put("zeta", "\u03b6");
        special.put("eta", "\u03b7");
        special.put("theta", "\u03b8");
        special.put("iota", "\u03b9");
        special.put("kappa", "\u03ba");
        special.put("lambda", "\u03bb");
        special.put("mu", "\u03bc");
        special.put("nu", "\u03bd");
        special.put("xi", "\u03be");
        special.put("pi", "\u03c0");
        special.put("rho", "\u03c1");
        special.put("sigma", "\u03c3");
        special.put("tau", "\u03c4");
        special.put("upsilon", "\u03c5");
        special.put("phi", "\u03c6");
        special.put("chi", "\u03c7");
        special.put("psi", "\u03c8");
        special.put("omega", "\u03c9");
        special.put("nabla", "\u2207");
        special.put("aleph", "\u2135");
        special.put("hbar", "\u210f");
        special.put("hamilt", "\u210b");
        special.put("lagran", "\u2112");
        special.put("square", "\u25a1");
        comparator = new Comparator(){

            public int compare(Object object, Object object2) {
                return Variable.value((Variable)object) - Variable.value((Variable)object2);
            }
        };
    }
}

