/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Expression;
import jscl.math.Function;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Matrix;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Rational;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;
import jscl.math.numeric.NumericMatrix;
import jscl.math.numeric.NumericVector;

public final class NumericWrapper
extends Generic {
    final Numeric content;

    public NumericWrapper(JSCLInteger jSCLInteger) {
        this.content = JSCLDouble.valueOf(jSCLInteger.content().doubleValue());
    }

    public NumericWrapper(Rational rational) {
        this.content = JSCLDouble.valueOf(rational.numerator().doubleValue() / rational.denominator().doubleValue());
    }

    public NumericWrapper(JSCLVector jSCLVector) {
        Numeric[] numericArray = new Numeric[jSCLVector.n];
        for (int i = 0; i < jSCLVector.n; ++i) {
            numericArray[i] = ((NumericWrapper)jSCLVector.element[i].numeric()).content();
        }
        this.content = new NumericVector(numericArray);
    }

    public NumericWrapper(Matrix matrix) {
        Numeric[][] numericArray = new Numeric[matrix.n][matrix.p];
        for (int i = 0; i < matrix.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                numericArray[i][j] = ((NumericWrapper)matrix.element[i][j].numeric()).content();
            }
        }
        this.content = new NumericMatrix(numericArray);
    }

    public NumericWrapper(Constant constant) {
        this.content = constant.numericValue();
    }

    public NumericWrapper(Numeric numeric) {
        this.content = numeric;
    }

    public Numeric content() {
        return this.content;
    }

    public NumericWrapper add(NumericWrapper numericWrapper) {
        return new NumericWrapper(this.content.add(numericWrapper.content));
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.add((NumericWrapper)generic);
        }
        return this.add(this.valueof(generic));
    }

    public NumericWrapper subtract(NumericWrapper numericWrapper) {
        return new NumericWrapper(this.content.subtract(numericWrapper.content));
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.subtract((NumericWrapper)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public NumericWrapper multiply(NumericWrapper numericWrapper) {
        return new NumericWrapper(this.content.multiply(numericWrapper.content));
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.multiply((NumericWrapper)generic);
        }
        return this.multiply(this.valueof(generic));
    }

    public boolean multiple(NumericWrapper numericWrapper) {
        return true;
    }

    @Override
    public boolean multiple(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.multiple((NumericWrapper)generic);
        }
        try {
            return this.multiple(this.valueof(generic));
        }
        catch (ArithmeticException arithmeticException) {
            return false;
        }
    }

    public NumericWrapper divide(NumericWrapper numericWrapper) throws ArithmeticException {
        return new NumericWrapper(this.content.divide(numericWrapper.content));
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof NumericWrapper) {
            return this.divide((NumericWrapper)generic);
        }
        return this.divide(this.valueof(generic));
    }

    @Override
    public Generic gcd(Generic generic) {
        return null;
    }

    @Override
    public Generic gcd() {
        return null;
    }

    @Override
    public Generic abs() {
        return new NumericWrapper(this.content.abs());
    }

    @Override
    public Generic negate() {
        return new NumericWrapper(this.content.negate());
    }

    @Override
    public int signum() {
        return this.content.signum();
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        return null;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        return this;
    }

    @Override
    public Generic eval() {
        return this;
    }

    @Override
    public Generic expand() {
        return this;
    }

    @Override
    public Generic factorize() {
        return this;
    }

    @Override
    public Generic elementary() {
        return this;
    }

    @Override
    public Generic simplify() {
        return this;
    }

    @Override
    public Generic function(Variable variable) {
        if (this.content instanceof JSCLDouble) {
            return Function.valueOf(((JSCLDouble)this.content).doubleValue());
        }
        throw new ArithmeticException();
    }

    @Override
    public Generic numeric() {
        return this;
    }

    public NumericWrapper valueof(NumericWrapper numericWrapper) {
        return new NumericWrapper(this.content.valueof(numericWrapper.content));
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.valueof((NumericWrapper)generic);
        }
        if (generic instanceof JSCLInteger) {
            return new NumericWrapper((JSCLInteger)generic);
        }
        if (generic instanceof Rational) {
            return new NumericWrapper((Rational)generic);
        }
        if (generic instanceof JSCLVector) {
            return new NumericWrapper((JSCLVector)generic);
        }
        if (generic instanceof Matrix) {
            return new NumericWrapper((Matrix)generic);
        }
        throw new ArithmeticException();
    }

    @Override
    public Generic[] sumValue() {
        return null;
    }

    @Override
    public Generic[] productValue() {
        return null;
    }

    @Override
    public Power powerValue() {
        return null;
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        if (this.content instanceof JSCLDouble) {
            return JSCLInteger.valueOf((int)((JSCLDouble)this.content).doubleValue());
        }
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return true;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return true;
    }

    public Generic log() {
        return new NumericWrapper(this.content.log());
    }

    public Generic exp() {
        return new NumericWrapper(this.content.exp());
    }

    public Generic pow(Generic generic) {
        return new NumericWrapper(this.content.pow(((NumericWrapper)generic).content));
    }

    public Generic sqrt() {
        return new NumericWrapper(this.content.sqrt());
    }

    public Generic nthrt(int n) {
        return new NumericWrapper(this.content.nthrt(n));
    }

    public static Generic root(int n, Generic[] genericArray) {
        Numeric[] numericArray = new Numeric[genericArray.length];
        for (int i = 0; i < numericArray.length; ++i) {
            numericArray[i] = ((NumericWrapper)genericArray[i]).content;
        }
        return new NumericWrapper(Numeric.root(n, numericArray));
    }

    public Generic conjugate() {
        return new NumericWrapper(this.content.conjugate());
    }

    public Generic acos() {
        return new NumericWrapper(this.content.acos());
    }

    public Generic asin() {
        return new NumericWrapper(this.content.asin());
    }

    public Generic atan() {
        return new NumericWrapper(this.content.atan());
    }

    public Generic acot() {
        return new NumericWrapper(this.content.acot());
    }

    public Generic cos() {
        return new NumericWrapper(this.content.cos());
    }

    public Generic sin() {
        return new NumericWrapper(this.content.sin());
    }

    public Generic tan() {
        return new NumericWrapper(this.content.tan());
    }

    public Generic cot() {
        return new NumericWrapper(this.content.cot());
    }

    public Generic acosh() {
        return new NumericWrapper(this.content.acosh());
    }

    public Generic asinh() {
        return new NumericWrapper(this.content.asinh());
    }

    public Generic atanh() {
        return new NumericWrapper(this.content.atanh());
    }

    public Generic acoth() {
        return new NumericWrapper(this.content.acoth());
    }

    public Generic cosh() {
        return new NumericWrapper(this.content.cosh());
    }

    public Generic sinh() {
        return new NumericWrapper(this.content.sinh());
    }

    public Generic tanh() {
        return new NumericWrapper(this.content.tanh());
    }

    public Generic coth() {
        return new NumericWrapper(this.content.coth());
    }

    public int compareTo(NumericWrapper numericWrapper) {
        return this.content.compareTo(numericWrapper.content);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof NumericWrapper) {
            return this.compareTo((NumericWrapper)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public String toString() {
        return this.content.toString();
    }

    @Override
    public String toMathML() {
        return this.content.toMathML();
    }

    protected Generic newinstance() {
        return null;
    }
}

