/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Conjugate;
import jscl.math.function.Constant;
import jscl.math.function.trigonometric.Cos;
import jscl.math.function.trigonometric.Sin;
import jscl.util.ArrayComparator;

public class Matrix
extends Generic {
    protected final Generic[][] element;
    protected final int n;
    protected final int p;

    public Matrix(String string, int n, int n2, int n3) {
        this(new Generic[n2][n3]);
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n3; ++j) {
                this.element[i][j] = new Constant(string, n, new Generic[]{JSCLInteger.valueOf(i), JSCLInteger.valueOf(j)}).expressionValue();
            }
        }
    }

    public Matrix(Generic[][] genericArray) {
        this.element = genericArray;
        this.n = genericArray.length;
        this.p = genericArray.length > 0 ? genericArray[0].length : 0;
    }

    public Generic[][] elements() {
        return this.element;
    }

    public Matrix add(Matrix matrix) {
        Matrix matrix2 = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix2.element[i][j] = this.element[i][j].add(matrix.element[i][j]);
            }
        }
        return matrix2;
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof Matrix) {
            return this.add((Matrix)generic);
        }
        return this.add(this.valueof(generic));
    }

    public Matrix subtract(Matrix matrix) {
        Matrix matrix2 = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix2.element[i][j] = this.element[i][j].subtract(matrix.element[i][j]);
            }
        }
        return matrix2;
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof Matrix) {
            return this.subtract((Matrix)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    public static boolean product(Generic generic, Generic generic2) {
        return generic instanceof Matrix && generic2 instanceof Matrix || generic instanceof Matrix && generic2 instanceof JSCLVector || generic instanceof JSCLVector && generic2 instanceof Matrix;
    }

    public Matrix multiply(Matrix matrix) {
        if (this.p != matrix.n) {
            throw new ArithmeticException();
        }
        Matrix matrix2 = (Matrix)this.newinstance(new Generic[this.n][matrix.p]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                matrix2.element[i][j] = JSCLInteger.valueOf(0L);
                for (int k = 0; k < this.p; ++k) {
                    matrix2.element[i][j] = matrix2.element[i][j].add(this.element[i][k].multiply(matrix.element[k][j]));
                }
            }
        }
        return matrix2;
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof Matrix) {
            return this.multiply((Matrix)generic);
        }
        if (generic instanceof JSCLVector) {
            JSCLVector jSCLVector = (JSCLVector)((JSCLVector)generic).newinstance(new Generic[this.n]);
            JSCLVector jSCLVector2 = (JSCLVector)generic;
            if (this.p != jSCLVector2.n) {
                throw new ArithmeticException();
            }
            for (int i = 0; i < this.n; ++i) {
                jSCLVector.element[i] = JSCLInteger.valueOf(0L);
                for (int j = 0; j < this.p; ++j) {
                    jSCLVector.element[i] = jSCLVector.element[i].add(this.element[i][j].multiply(jSCLVector2.element[j]));
                }
            }
            return jSCLVector;
        }
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].multiply(generic);
            }
        }
        return matrix;
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof Matrix) {
            return this.multiply(((Matrix)generic).inverse());
        }
        if (generic instanceof JSCLVector) {
            throw new ArithmeticException();
        }
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].divide(generic);
            }
        }
        return matrix;
    }

    @Override
    public Generic gcd(Generic generic) {
        return null;
    }

    @Override
    public Generic gcd() {
        return null;
    }

    @Override
    public Generic negate() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].negate();
            }
        }
        return matrix;
    }

    @Override
    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                int n = this.element[i][j].signum();
                if (n < 0) {
                    return -1;
                }
                if (n <= 0) continue;
                return 1;
            }
        }
        return 0;
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].antiderivative(variable);
            }
        }
        return matrix;
    }

    @Override
    public Generic derivative(Variable variable) {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].derivative(variable);
            }
        }
        return matrix;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].substitute(variable, generic);
            }
        }
        return matrix;
    }

    @Override
    public Generic eval() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].eval();
            }
        }
        return matrix;
    }

    @Override
    public Generic expand() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].expand();
            }
        }
        return matrix;
    }

    @Override
    public Generic factorize() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].factorize();
            }
        }
        return matrix;
    }

    @Override
    public Generic elementary() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].elementary();
            }
        }
        return matrix;
    }

    @Override
    public Generic simplify() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].simplify();
            }
        }
        return matrix;
    }

    @Override
    public Generic function(Variable variable) {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = this.element[i][j].function(variable);
            }
        }
        return matrix;
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof Matrix || generic instanceof JSCLVector) {
            throw new ArithmeticException();
        }
        Matrix matrix = (Matrix)Matrix.identity(this.n, this.p).multiply(generic);
        return this.newinstance(matrix.element);
    }

    @Override
    public Generic[] sumValue() {
        return new Generic[]{this};
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        return new Generic[]{this};
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return new Power(this, 1);
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return false;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return false;
    }

    public Generic[] vectors() {
        Generic[] genericArray = new JSCLVector[this.n];
        for (int i = 0; i < this.n; ++i) {
            genericArray[i] = new JSCLVector(new Generic[this.p]);
            for (int j = 0; j < this.p; ++j) {
                ((JSCLVector)genericArray[i]).element[j] = this.element[i][j];
            }
        }
        return genericArray;
    }

    public Generic tensorProduct(Matrix matrix) {
        Matrix matrix2 = (Matrix)this.newinstance(new Generic[this.n * matrix.n][this.p * matrix.p]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                for (int k = 0; k < matrix.n; ++k) {
                    for (int i2 = 0; i2 < matrix.p; ++i2) {
                        matrix2.element[i * matrix.n + k][j * matrix.p + i2] = this.element[i][j].multiply(matrix.element[k][i2]);
                    }
                }
            }
        }
        return matrix2;
    }

    public Generic transpose() {
        Matrix matrix = (Matrix)this.newinstance(new Generic[this.p][this.n]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[j][i] = this.element[i][j];
            }
        }
        return matrix;
    }

    public Generic trace() {
        Generic generic = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.n; ++i) {
            generic = ((Generic)generic).add(this.element[i][i]);
        }
        return generic;
    }

    @Override
    public Generic inverse() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                matrix.element[i][j] = this.inverseElement(i, j);
            }
        }
        return matrix.transpose().divide(this.determinant());
    }

    Generic inverseElement(int n, int n2) {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                matrix.element[i][j] = i == n ? JSCLInteger.valueOf(j == n2 ? 1L : 0L) : this.element[i][j];
            }
        }
        return matrix.determinant();
    }

    public Generic determinant() {
        if (this.n > 1) {
            Generic generic = JSCLInteger.valueOf(0L);
            for (int i = 0; i < this.n; ++i) {
                if (this.element[i][0].signum() == 0) continue;
                Matrix matrix = (Matrix)this.newinstance(new Generic[this.n - 1][this.n - 1]);
                for (int j = 0; j < this.n - 1; ++j) {
                    for (int k = 0; k < this.n - 1; ++k) {
                        matrix.element[j][k] = this.element[j < i ? j : j + 1][k + 1];
                    }
                }
                generic = i % 2 == 0 ? ((Generic)generic).add(this.element[i][0].multiply(matrix.determinant())) : ((Generic)generic).subtract(this.element[i][0].multiply(matrix.determinant()));
            }
            return generic;
        }
        if (this.n > 0) {
            return this.element[0][0];
        }
        return JSCLInteger.valueOf(0L);
    }

    public Generic conjugate() {
        Matrix matrix = (Matrix)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < this.p; ++j) {
                matrix.element[i][j] = new Conjugate(this.element[i][j]).evaluate();
            }
        }
        return matrix;
    }

    public int compareTo(Matrix matrix) {
        return ArrayComparator.comparator.compare(this.vectors(), matrix.vectors());
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof Matrix) {
            return this.compareTo((Matrix)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static Matrix identity(int n) {
        return Matrix.identity(n, n);
    }

    public static Matrix identity(int n, int n2) {
        Matrix matrix = new Matrix(new Generic[n][n2]);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n2; ++j) {
                matrix.element[i][j] = i == j ? JSCLInteger.valueOf(1L) : JSCLInteger.valueOf(0L);
            }
        }
        return matrix;
    }

    public static Matrix frame(JSCLVector[] jSCLVectorArray) {
        Matrix matrix = new Matrix(new Generic[jSCLVectorArray.length > 0 ? jSCLVectorArray[0].n : 0][jSCLVectorArray.length]);
        for (int i = 0; i < matrix.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                matrix.element[i][j] = jSCLVectorArray[j].element[i];
            }
        }
        return matrix;
    }

    public static Matrix rotation(int n, int n2, Generic generic) {
        return Matrix.rotation(n, n2, 2, generic);
    }

    public static Matrix rotation(int n, int n2, int n3, Generic generic) {
        Matrix matrix = new Matrix(new Generic[n][n]);
        for (int i = 0; i < matrix.n; ++i) {
            for (int j = 0; j < matrix.p; ++j) {
                matrix.element[i][j] = i == n2 && j == n2 ? new Cos(generic).evaluate() : (i == n2 && j == n3 ? new Sin(generic).evaluate().negate() : (i == n3 && j == n2 ? new Sin(generic).evaluate() : (i == n3 && j == n3 ? new Cos(generic).evaluate() : (i == j ? JSCLInteger.valueOf(1L) : JSCLInteger.valueOf(0L)))));
            }
        }
        return matrix;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append("{");
            for (int j = 0; j < this.p; ++j) {
                stringBuffer.append(this.element[i][j]).append(j < this.p - 1 ? ", " : "");
            }
            stringBuffer.append("}").append(i < this.n - 1 ? ",\n" : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<matrix>");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append("<matrixrow>");
            for (int j = 0; j < this.p; ++j) {
                stringBuffer.append(this.element[i][j].toMathML());
            }
            stringBuffer.append("</matrixrow>");
        }
        stringBuffer.append("</matrix>");
        return stringBuffer.toString();
    }

    protected Generic newinstance() {
        return this.newinstance(new Generic[this.n][this.p]);
    }

    protected Generic newinstance(Generic[][] genericArray) {
        return new Matrix(genericArray);
    }
}

