/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import jscl.math.Clifford;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Matrix;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Conjugate;
import jscl.math.function.Constant;
import jscl.util.ArrayComparator;

public class JSCLVector
extends Generic {
    protected final Generic[] element;
    protected final int n;

    public JSCLVector(String string, int n, int n2) {
        this(new Generic[n2]);
        for (int i = 0; i < n2; ++i) {
            this.element[i] = new Constant(string, n, new Generic[]{JSCLInteger.valueOf(i)}).expressionValue();
        }
    }

    public JSCLVector(Generic[] genericArray) {
        this.element = genericArray;
        this.n = genericArray.length;
    }

    public Generic[] elements() {
        return this.element;
    }

    public JSCLVector add(JSCLVector jSCLVector) {
        JSCLVector jSCLVector2 = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector2.element[i] = this.element[i].add(jSCLVector.element[i]);
        }
        return jSCLVector2;
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.add((JSCLVector)generic);
        }
        return this.add(this.valueof(generic));
    }

    public JSCLVector subtract(JSCLVector jSCLVector) {
        JSCLVector jSCLVector2 = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector2.element[i] = this.element[i].subtract(jSCLVector.element[i]);
        }
        return jSCLVector2;
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.subtract((JSCLVector)generic);
        }
        return this.subtract(this.valueof(generic));
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.scalarProduct((JSCLVector)generic);
        }
        if (generic instanceof Matrix) {
            return ((Matrix)generic).transpose().multiply(this);
        }
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].multiply(generic);
        }
        return jSCLVector;
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof JSCLVector) {
            throw new ArithmeticException();
        }
        if (generic instanceof Matrix) {
            return this.multiply(((Matrix)generic).inverse());
        }
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].divide(generic);
        }
        return jSCLVector;
    }

    @Override
    public Generic gcd(Generic generic) {
        return null;
    }

    @Override
    public Generic gcd() {
        return null;
    }

    @Override
    public Generic negate() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].negate();
        }
        return jSCLVector;
    }

    @Override
    public int signum() {
        for (int i = 0; i < this.n; ++i) {
            int n = this.element[i].signum();
            if (n < 0) {
                return -1;
            }
            if (n <= 0) continue;
            return 1;
        }
        return 0;
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].antiderivative(variable);
        }
        return jSCLVector;
    }

    @Override
    public Generic derivative(Variable variable) {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].derivative(variable);
        }
        return jSCLVector;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].substitute(variable, generic);
        }
        return jSCLVector;
    }

    @Override
    public Generic eval() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].eval();
        }
        return jSCLVector;
    }

    @Override
    public Generic expand() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].expand();
        }
        return jSCLVector;
    }

    @Override
    public Generic factorize() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].factorize();
        }
        return jSCLVector;
    }

    @Override
    public Generic elementary() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].elementary();
        }
        return jSCLVector;
    }

    @Override
    public Generic simplify() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].simplify();
        }
        return jSCLVector;
    }

    @Override
    public Generic function(Variable variable) {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i].function(variable);
        }
        return jSCLVector;
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof JSCLVector || generic instanceof Matrix) {
            throw new ArithmeticException();
        }
        JSCLVector jSCLVector = (JSCLVector)JSCLVector.unity(this.n).multiply(generic);
        return this.newinstance(jSCLVector.element);
    }

    @Override
    public Generic[] sumValue() {
        return new Generic[]{this};
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        return new Generic[]{this};
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return new Power(this, 1);
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        throw new NotExpressionException();
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        throw new NotIntegerException();
    }

    @Override
    public JSCLVector vectorValue() {
        return this;
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return false;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return false;
    }

    public Generic magnitude2() {
        return this.scalarProduct(this);
    }

    public Generic scalarProduct(JSCLVector jSCLVector) {
        Generic generic = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.n; ++i) {
            generic = ((Generic)generic).add(this.element[i].multiply(jSCLVector.element[i]));
        }
        return generic;
    }

    public JSCLVector vectorProduct(JSCLVector jSCLVector) {
        JSCLVector jSCLVector2 = (JSCLVector)this.newinstance();
        Generic[][] genericArray = new Generic[][]{{JSCLInteger.valueOf(0L), this.element[2].negate(), this.element[1]}, {this.element[2], JSCLInteger.valueOf(0L), this.element[0].negate()}, {this.element[1].negate(), this.element[0], JSCLInteger.valueOf(0L)}};
        JSCLVector jSCLVector3 = (JSCLVector)new Matrix(genericArray).multiply(jSCLVector);
        for (int i = 0; i < this.n; ++i) {
            jSCLVector2.element[i] = i < jSCLVector3.n ? jSCLVector3.element[i] : JSCLInteger.valueOf(0L);
        }
        return jSCLVector2;
    }

    public JSCLVector complexProduct(JSCLVector jSCLVector) {
        return this.product(new Clifford(0, 1).operator(), jSCLVector);
    }

    public JSCLVector quaternionProduct(JSCLVector jSCLVector) {
        return this.product(new Clifford(0, 2).operator(), jSCLVector);
    }

    public JSCLVector geometricProduct(JSCLVector jSCLVector, int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            int[] nArray3 = new int[2];
            nArray3[0] = Clifford.log2e(this.n);
            nArray2 = nArray3;
            nArray3[1] = 0;
        } else {
            nArray2 = nArray;
        }
        return this.product(new Clifford(nArray2).operator(), jSCLVector);
    }

    JSCLVector product(int[][] nArray, JSCLVector jSCLVector) {
        int n;
        JSCLVector jSCLVector2 = (JSCLVector)this.newinstance();
        for (n = 0; n < this.n; ++n) {
            jSCLVector2.element[n] = JSCLInteger.valueOf(0L);
        }
        for (n = 0; n < this.n; ++n) {
            for (int i = 0; i < this.n; ++i) {
                Generic generic = this.element[n].multiply(jSCLVector.element[i]);
                int n2 = Math.abs(nArray[n][i]) - 1;
                jSCLVector2.element[n2] = jSCLVector2.element[n2].add(nArray[n][i] < 0 ? generic.negate() : generic);
            }
        }
        return jSCLVector2;
    }

    public Generic divergence(Variable[] variableArray) {
        Generic generic = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.n; ++i) {
            generic = ((Generic)generic).add(this.element[i].derivative(variableArray[i]));
        }
        return generic;
    }

    public JSCLVector curl(Variable[] variableArray) {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        jSCLVector.element[0] = this.element[2].derivative(variableArray[1]).subtract(this.element[1].derivative(variableArray[2]));
        jSCLVector.element[1] = this.element[0].derivative(variableArray[2]).subtract(this.element[2].derivative(variableArray[0]));
        jSCLVector.element[2] = this.element[1].derivative(variableArray[0]).subtract(this.element[0].derivative(variableArray[1]));
        for (int i = 3; i < this.n; ++i) {
            jSCLVector.element[i] = this.element[i];
        }
        return jSCLVector;
    }

    public Matrix jacobian(Variable[] variableArray) {
        Matrix matrix = new Matrix(new Generic[this.n][variableArray.length]);
        for (int i = 0; i < this.n; ++i) {
            for (int j = 0; j < variableArray.length; ++j) {
                matrix.element[i][j] = this.element[i].derivative(variableArray[j]);
            }
        }
        return matrix;
    }

    public Generic del(Variable[] variableArray, int[] nArray) {
        int[] nArray2;
        if (nArray == null) {
            int[] nArray3 = new int[2];
            nArray3[0] = Clifford.log2e(this.n);
            nArray2 = nArray3;
            nArray3[1] = 0;
        } else {
            nArray2 = nArray;
        }
        return this.differential(new Clifford(nArray2).operator(), variableArray);
    }

    JSCLVector differential(int[][] nArray, Variable[] variableArray) {
        int n;
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (n = 0; n < this.n; ++n) {
            jSCLVector.element[n] = JSCLInteger.valueOf(0L);
        }
        n = Clifford.log2e(this.n);
        for (int i = 1; i <= n; ++i) {
            for (int j = 0; j < this.n; ++j) {
                Generic generic = this.element[j].derivative(variableArray[i - 1]);
                int n2 = Math.abs(nArray[i][j]) - 1;
                jSCLVector.element[n2] = jSCLVector.element[n2].add(nArray[i][j] < 0 ? generic.negate() : generic);
            }
        }
        return jSCLVector;
    }

    public Generic conjugate() {
        JSCLVector jSCLVector = (JSCLVector)this.newinstance();
        for (int i = 0; i < this.n; ++i) {
            jSCLVector.element[i] = new Conjugate(this.element[i]).evaluate();
        }
        return jSCLVector;
    }

    public int compareTo(JSCLVector jSCLVector) {
        return ArrayComparator.comparator.compare(this.element, jSCLVector.element);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof JSCLVector) {
            return this.compareTo((JSCLVector)generic);
        }
        return this.compareTo(this.valueof(generic));
    }

    public static JSCLVector unity(int n) {
        JSCLVector jSCLVector = new JSCLVector(new Generic[n]);
        for (int i = 0; i < jSCLVector.n; ++i) {
            jSCLVector.element[i] = i == 0 ? JSCLInteger.valueOf(1L) : JSCLInteger.valueOf(0L);
        }
        return jSCLVector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append(this.element[i]).append(i < this.n - 1 ? ", " : "");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<vector>");
        for (int i = 0; i < this.n; ++i) {
            stringBuffer.append(this.element[i].toMathML());
        }
        stringBuffer.append("</vector>");
        return stringBuffer.toString();
    }

    protected Generic newinstance() {
        return this.newinstance(new Generic[this.n]);
    }

    protected Generic newinstance(Generic[] genericArray) {
        return new JSCLVector(genericArray);
    }
}

