/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.util.ArrayList;
import java.util.Map;
import jscl.math.Factorization;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.JSCLVector;
import jscl.math.Literal;
import jscl.math.Matrix;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.Power;
import jscl.math.Rational;
import jscl.math.Simplification;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.UnivariatePolynomial;
import jscl.text.ExpressionParser;
import jscl.text.ParseException;
import jscl.text.Parser;
import jscl.util.ArrayUtils;

public class Expression
extends Generic {
    Literal[] literal;
    JSCLInteger[] coef;
    int size;

    Expression() {
    }

    Expression(int n) {
        this.init(n);
    }

    public int size() {
        return this.size;
    }

    public Literal literal(int n) {
        return this.literal[n];
    }

    public JSCLInteger coef(int n) {
        return this.coef[n];
    }

    void init(int n) {
        this.literal = new Literal[n];
        this.coef = new JSCLInteger[n];
        this.size = n;
    }

    void resize(int n) {
        int n2 = this.literal.length;
        if (n < n2) {
            Literal[] literalArray = new Literal[n];
            JSCLInteger[] jSCLIntegerArray = new JSCLInteger[n];
            System.arraycopy(this.literal, n2 - n, literalArray, 0, n);
            System.arraycopy(this.coef, n2 - n, jSCLIntegerArray, 0, n);
            this.literal = literalArray;
            this.coef = jSCLIntegerArray;
            this.size = n;
        }
    }

    public Expression add(Expression expression) {
        Literal literal;
        Expression expression2 = this.newinstance(this.size + expression.size);
        int n = expression2.size;
        int n2 = this.size;
        int n3 = expression.size;
        Literal literal2 = n2 > 0 ? this.literal[--n2] : null;
        Literal literal3 = literal = n3 > 0 ? expression.literal[--n3] : null;
        while (literal2 != null || literal != null) {
            JSCLInteger jSCLInteger;
            int n4;
            int n5 = literal2 == null ? 1 : (n4 = literal == null ? -1 : -literal2.compareTo(literal));
            if (n4 < 0) {
                jSCLInteger = this.coef[n2];
                expression2.literal[--n] = literal2;
                expression2.coef[n] = jSCLInteger;
                literal2 = n2 > 0 ? this.literal[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                jSCLInteger = expression.coef[n3];
                expression2.literal[--n] = literal;
                expression2.coef[n] = jSCLInteger;
                literal = n3 > 0 ? expression.literal[--n3] : null;
                continue;
            }
            jSCLInteger = this.coef[n2].add(expression.coef[n3]);
            if (jSCLInteger.signum() != 0) {
                expression2.literal[--n] = literal2;
                expression2.coef[n] = jSCLInteger;
            }
            literal2 = n2 > 0 ? this.literal[--n2] : null;
            literal = n3 > 0 ? expression.literal[--n3] : null;
        }
        expression2.resize(expression2.size - n);
        return expression2;
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof Expression) {
            return this.add((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.add(this.valueof(generic));
        }
        return generic.valueof(this).add(generic);
    }

    public Expression subtract(Expression expression) {
        return this.multiplyAndAdd(Literal.valueOf(), JSCLInteger.valueOf(-1L), expression);
    }

    @Override
    public Generic subtract(Generic generic) {
        if (generic instanceof Expression) {
            return this.subtract((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.subtract(this.valueof(generic));
        }
        return generic.valueof(this).subtract(generic);
    }

    Expression multiplyAndAdd(Literal literal, JSCLInteger jSCLInteger, Expression expression) {
        Literal literal2;
        if (jSCLInteger.signum() == 0) {
            return this;
        }
        Expression expression2 = this.newinstance(this.size + expression.size);
        int n = expression2.size;
        int n2 = this.size;
        int n3 = expression.size;
        Literal literal3 = n2 > 0 ? this.literal[--n2] : null;
        Literal literal4 = literal2 = n3 > 0 ? expression.literal[--n3].multiply(literal) : null;
        while (literal3 != null || literal2 != null) {
            JSCLInteger jSCLInteger2;
            int n4;
            int n5 = literal3 == null ? 1 : (n4 = literal2 == null ? -1 : -literal3.compareTo(literal2));
            if (n4 < 0) {
                jSCLInteger2 = this.coef[n2];
                expression2.literal[--n] = literal3;
                expression2.coef[n] = jSCLInteger2;
                literal3 = n2 > 0 ? this.literal[--n2] : null;
                continue;
            }
            if (n4 > 0) {
                jSCLInteger2 = expression.coef[n3].multiply(jSCLInteger);
                expression2.literal[--n] = literal2;
                expression2.coef[n] = jSCLInteger2;
                literal2 = n3 > 0 ? expression.literal[--n3].multiply(literal) : null;
                continue;
            }
            jSCLInteger2 = this.coef[n2].add(expression.coef[n3].multiply(jSCLInteger));
            if (jSCLInteger2.signum() != 0) {
                expression2.literal[--n] = literal3;
                expression2.coef[n] = jSCLInteger2;
            }
            literal3 = n2 > 0 ? this.literal[--n2] : null;
            literal2 = n3 > 0 ? expression.literal[--n3].multiply(literal) : null;
        }
        expression2.resize(expression2.size - n);
        return expression2;
    }

    public Expression multiply(Expression expression) {
        Expression expression2 = this.newinstance(0);
        for (int i = 0; i < this.size; ++i) {
            expression2 = expression2.multiplyAndAdd(this.literal[i], this.coef[i], expression);
        }
        return expression2;
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof Expression) {
            return this.multiply((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.multiply(this.valueof(generic));
        }
        return generic.multiply(this);
    }

    @Override
    public boolean multiple(Generic generic) throws ArithmeticException {
        return this.remainder(generic).signum() == 0;
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        Generic[] genericArray = this.divideAndRemainder(generic);
        if (genericArray[1].signum() == 0) {
            return genericArray[0];
        }
        return new Frac(this, generic).evaluate();
    }

    @Override
    public Generic[] divideAndRemainder(Generic generic) throws ArithmeticException {
        if (generic instanceof Expression) {
            Literal literal;
            Expression expression = (Expression)generic;
            Literal literal2 = this.literalScm();
            Literal literal3 = literal2.gcd(literal = expression.literalScm());
            Variable[] variableArray = literal3.variables();
            if (variableArray.length == 0) {
                if (this.signum() == 0 && expression.signum() != 0) {
                    return new Generic[]{this, JSCLInteger.valueOf(0L)};
                }
                try {
                    return this.divideAndRemainder(expression.integerValue());
                }
                catch (NotIntegerException notIntegerException) {
                    return new Generic[]{JSCLInteger.valueOf(0L), this};
                }
            }
            Polynomial polynomial = Polynomial.factory(variableArray[0]);
            Polynomial[] polynomialArray = polynomial.valueof(this).divideAndRemainder(polynomial.valueof(expression));
            return new Generic[]{polynomialArray[0].genericValue(), polynomialArray[1].genericValue()};
        }
        if (generic instanceof JSCLInteger) {
            JSCLInteger jSCLInteger = (JSCLInteger)generic;
            boolean bl = true;
            Expression expression = this.newinstance(this.size);
            for (int i = 0; i < this.size; ++i) {
                if (this.coef[i].multiple(jSCLInteger)) {
                    expression.literal[i] = this.literal[i];
                    expression.coef[i] = this.coef[i].integerDivide(jSCLInteger);
                    continue;
                }
                bl = false;
            }
            if (bl) {
                return new Generic[]{expression, JSCLInteger.valueOf(0L)};
            }
            return new Generic[]{JSCLInteger.valueOf(0L), this};
        }
        if (generic instanceof Rational) {
            return this.divideAndRemainder(this.valueof(generic));
        }
        try {
            return generic.valueof(this).divideAndRemainder(generic);
        }
        catch (ArithmeticException arithmeticException) {
            return new Generic[]{JSCLInteger.valueOf(0L), this};
        }
    }

    @Override
    public Generic gcd(Generic generic) {
        if (generic instanceof Expression) {
            Literal literal;
            Expression expression = (Expression)generic;
            Literal literal2 = this.literalScm();
            Literal literal3 = literal2.gcd(literal = expression.literalScm());
            Variable[] variableArray = literal3.variables();
            if (variableArray.length == 0) {
                if (this.signum() == 0) {
                    return expression;
                }
                return this.gcd(expression.gcd());
            }
            Polynomial polynomial = Polynomial.factory(variableArray[0]);
            return polynomial.valueof(this).gcd(polynomial.valueof(expression)).genericValue();
        }
        if (generic instanceof JSCLInteger) {
            if (generic.signum() == 0) {
                return this;
            }
            return this.gcd().gcd(generic);
        }
        if (generic instanceof Rational) {
            return this.gcd(this.valueof(generic));
        }
        return generic.valueof(this).gcd(generic);
    }

    @Override
    public Generic gcd() {
        JSCLInteger jSCLInteger = JSCLInteger.valueOf(0L);
        for (int i = this.size - 1; i >= 0; --i) {
            jSCLInteger = jSCLInteger.gcd(this.coef[i]);
        }
        return jSCLInteger;
    }

    public Literal literalScm() {
        Literal literal = Literal.valueOf();
        for (int i = 0; i < this.size; ++i) {
            literal = literal.scm(this.literal[i]);
        }
        return literal;
    }

    @Override
    public Generic negate() {
        return this.multiply(JSCLInteger.valueOf(-1L));
    }

    @Override
    public int signum() {
        return this.size == 0 ? 0 : this.coef[0].signum();
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        block10: {
            if (this.isPolynomial(variable)) {
                return ((UnivariatePolynomial)Polynomial.factory(variable).valueof(this)).antiderivative().genericValue();
            }
            try {
                Variable variable2 = this.variableValue();
                try {
                    return variable2.antiderivative(variable);
                }
                catch (NotIntegrableException notIntegrableException) {
                    Generic[] genericArray;
                    if (variable2 instanceof Frac && (genericArray = ((Frac)variable2).parameters())[1].isConstant(variable)) {
                        return new Inv(genericArray[1]).evaluate().multiply(genericArray[0].antiderivative(variable));
                    }
                }
            }
            catch (NotVariableException notVariableException) {
                Generic[] genericArray = this.sumValue();
                if (genericArray.length > 1) {
                    Generic generic = JSCLInteger.valueOf(0L);
                    for (int i = 0; i < genericArray.length; ++i) {
                        generic = ((Generic)generic).add(genericArray[i].antiderivative(variable));
                    }
                    return generic;
                }
                Generic[] genericArray2 = genericArray[0].productValue();
                Generic generic = JSCLInteger.valueOf(1L);
                Generic generic2 = JSCLInteger.valueOf(1L);
                for (int i = 0; i < genericArray2.length; ++i) {
                    if (genericArray2[i].isConstant(variable)) {
                        generic = ((Generic)generic).multiply(genericArray2[i]);
                        continue;
                    }
                    generic2 = ((Generic)generic2).multiply(genericArray2[i]);
                }
                if (((Generic)generic).compareTo(JSCLInteger.valueOf(1L)) == 0) break block10;
                return ((Generic)generic).multiply(((Generic)generic2).antiderivative(variable));
            }
        }
        throw new NotIntegrableException();
    }

    @Override
    public Generic derivative(Variable variable) {
        Generic generic = JSCLInteger.valueOf(0L);
        Literal literal = this.literalScm();
        int n = literal.size;
        for (int i = 0; i < n; ++i) {
            Variable variable2 = literal.variable[i];
            Generic generic2 = ((UnivariatePolynomial)Polynomial.factory(variable2).valueof(this)).derivative(variable).genericValue();
            generic = ((Generic)generic).add(generic2);
        }
        return generic;
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Map map = this.literalScm().content();
        for (Map.Entry entry : map.entrySet()) {
            Variable variable2 = (Variable)entry.getKey();
            entry.setValue(variable2.substitute(variable, generic));
        }
        return this.substitute(map);
    }

    Generic substitute(Map map) {
        JSCLInteger jSCLInteger = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.size; ++i) {
            Literal literal = this.literal[i];
            Generic generic = this.coef[i];
            int n = literal.size;
            for (int j = 0; j < n; ++j) {
                Variable variable = literal.variable[j];
                int n2 = literal.power[j];
                Generic generic2 = (Generic)map.get(variable);
                if (Matrix.product(generic, generic2 = generic2.pow(n2))) {
                    throw new ArithmeticException();
                }
                generic = generic.isOne() ? generic2 : ((Generic)generic).multiply(generic2);
            }
            jSCLInteger = jSCLInteger.isZero() ? generic : ((Generic)jSCLInteger).add(generic);
        }
        return jSCLInteger;
    }

    @Override
    public Generic eval() {
        Map map = this.literalScm().content();
        for (Map.Entry entry : map.entrySet()) {
            Variable variable = (Variable)entry.getKey();
            entry.setValue(variable.eval());
        }
        return this.substitute(map);
    }

    @Override
    public Generic expand() {
        Map map = this.literalScm().content();
        for (Map.Entry entry : map.entrySet()) {
            Variable variable = (Variable)entry.getKey();
            entry.setValue(variable.expand());
        }
        return this.substitute(map);
    }

    @Override
    public Generic factorize() {
        Map map = this.literalScm().content();
        for (Map.Entry object2 : map.entrySet()) {
            Variable variable = (Variable)object2.getKey();
            object2.setValue(variable.factorize());
        }
        Generic generic = this.substitute(map);
        return Factorization.compute(generic);
    }

    @Override
    public Generic elementary() {
        Map map = this.literalScm().content();
        for (Map.Entry entry : map.entrySet()) {
            Variable variable = (Variable)entry.getKey();
            entry.setValue(variable.elementary());
        }
        return this.substitute(map);
    }

    @Override
    public Generic simplify() {
        return Simplification.compute(this);
    }

    @Override
    public Generic function(Variable variable) {
        Map map = this.literalScm().content();
        for (Map.Entry entry : map.entrySet()) {
            Variable variable2 = (Variable)entry.getKey();
            entry.setValue(variable2.function(variable));
        }
        return this.substitute(map);
    }

    @Override
    public Generic numeric() {
        try {
            return this.integerValue().numeric();
        }
        catch (NotIntegerException notIntegerException) {
            Map map = this.literalScm().content();
            for (Map.Entry entry : map.entrySet()) {
                Variable variable = (Variable)entry.getKey();
                entry.setValue(variable.numeric());
            }
            return this.substitute(map);
        }
    }

    @Override
    public Generic valueof(Generic generic) {
        Expression expression = this.newinstance(0);
        expression.init(generic);
        return expression;
    }

    @Override
    public Generic[] sumValue() {
        Generic[] genericArray = new Generic[this.size];
        for (int i = 0; i < genericArray.length; ++i) {
            genericArray[i] = Expression.valueOf(this.literal[i], this.coef[i]);
        }
        return genericArray;
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        if (this.size == 0) {
            return new Generic[]{JSCLInteger.valueOf(0L)};
        }
        if (this.size == 1) {
            Literal literal = this.literal[0];
            JSCLInteger jSCLInteger = this.coef[0];
            Generic[] genericArray = literal.productValue();
            if (jSCLInteger.compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return genericArray;
            }
            Generic[] genericArray2 = new Generic[genericArray.length + 1];
            for (int i = 0; i < genericArray.length; ++i) {
                genericArray2[i + 1] = genericArray[i];
            }
            genericArray2[0] = jSCLInteger;
            return genericArray2;
        }
        throw new NotProductException();
    }

    @Override
    public Power powerValue() throws NotPowerException {
        if (this.size == 0) {
            return new Power(JSCLInteger.valueOf(0L), 1);
        }
        if (this.size == 1) {
            Literal literal = this.literal[0];
            JSCLInteger jSCLInteger = this.coef[0];
            if (jSCLInteger.compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return literal.powerValue();
            }
            if (literal.degree() == 0) {
                return jSCLInteger.powerValue();
            }
            throw new NotPowerException();
        }
        throw new NotPowerException();
    }

    @Override
    public Expression expressionValue() {
        return this;
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        if (this.size == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.size == 1) {
            Literal literal = this.literal[0];
            JSCLInteger jSCLInteger = this.coef[0];
            if (literal.degree() == 0) {
                return jSCLInteger;
            }
            throw new NotIntegerException();
        }
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        if (this.size == 0) {
            throw new NotVariableException();
        }
        if (this.size == 1) {
            Literal literal = this.literal[0];
            JSCLInteger jSCLInteger = this.coef[0];
            if (jSCLInteger.compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return literal.variableValue();
            }
            throw new NotVariableException();
        }
        throw new NotVariableException();
    }

    @Override
    public Variable[] variables() {
        return this.literalScm().variables();
    }

    public static Variable[] variables(Generic[] genericArray) {
        ArrayList<Variable> arrayList = new ArrayList<Variable>();
        for (int i = 0; i < genericArray.length; ++i) {
            Variable[] variableArray = genericArray[i].variables();
            for (int j = 0; j < variableArray.length; ++j) {
                Variable variable = variableArray[j];
                if (arrayList.contains(variable)) continue;
                arrayList.add(variable);
            }
        }
        return (Variable[])ArrayUtils.toArray(arrayList, new Variable[arrayList.size()]);
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        boolean bl = true;
        Literal literal = this.literalScm();
        int n = literal.size;
        for (int i = 0; i < n; ++i) {
            Variable variable2 = literal.variable[i];
            bl = bl && (variable2.isConstant(variable) || variable2.isIdentity(variable));
        }
        return bl;
    }

    @Override
    public boolean isConstant(Variable variable) {
        boolean bl = true;
        Literal literal = this.literalScm();
        int n = literal.size;
        for (int i = 0; i < n; ++i) {
            Variable variable2 = literal.variable[i];
            bl = bl && variable2.isConstant(variable);
        }
        return bl;
    }

    public JSCLVector grad(Variable[] variableArray) {
        Generic[] genericArray = new Generic[variableArray.length];
        for (int i = 0; i < variableArray.length; ++i) {
            genericArray[i] = this.derivative(variableArray[i]);
        }
        return new JSCLVector(genericArray);
    }

    public Generic laplacian(Variable[] variableArray) {
        return this.grad(variableArray).divergence(variableArray);
    }

    public Generic dalembertian(Variable[] variableArray) {
        Generic generic = this.derivative(variableArray[0]).derivative(variableArray[0]);
        for (int i = 1; i < 4; ++i) {
            generic = generic.subtract(this.derivative(variableArray[i]).derivative(variableArray[i]));
        }
        return generic;
    }

    public int compareTo(Expression expression) {
        Literal literal;
        int n = this.size;
        int n2 = expression.size;
        Literal literal2 = n == 0 ? null : this.literal[--n];
        Literal literal3 = literal = n2 == 0 ? null : expression.literal[--n2];
        while (literal2 != null || literal != null) {
            int n3;
            int n4 = literal2 == null ? -1 : (n3 = literal == null ? 1 : literal2.compareTo(literal));
            if (n3 < 0) {
                return -1;
            }
            if (n3 > 0) {
                return 1;
            }
            n3 = this.coef[n].compareTo(expression.coef[n2]);
            if (n3 < 0) {
                return -1;
            }
            if (n3 > 0) {
                return 1;
            }
            literal2 = n == 0 ? null : this.literal[--n];
            literal = n2 == 0 ? null : expression.literal[--n2];
        }
        return 0;
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof Expression) {
            return this.compareTo((Expression)generic);
        }
        if (generic instanceof JSCLInteger || generic instanceof Rational) {
            return this.compareTo(this.valueof(generic));
        }
        return generic.valueof(this).compareTo(generic);
    }

    public static Expression valueOf(Variable variable) {
        return Expression.valueOf(Literal.valueOf(variable));
    }

    public static Expression valueOf(Literal literal) {
        return Expression.valueOf(literal, JSCLInteger.valueOf(1L));
    }

    public static Expression valueOf(JSCLInteger jSCLInteger) {
        return Expression.valueOf(Literal.valueOf(), jSCLInteger);
    }

    public static Expression valueOf(Literal literal, JSCLInteger jSCLInteger) {
        Expression expression = new Expression();
        expression.init(literal, jSCLInteger);
        return expression;
    }

    void init(Literal literal, JSCLInteger jSCLInteger) {
        if (jSCLInteger.signum() != 0) {
            this.init(1);
            this.literal[0] = literal;
            this.coef[0] = jSCLInteger;
        } else {
            this.init(0);
        }
    }

    public static Expression valueOf(Rational rational) {
        Expression expression = new Expression();
        expression.init(rational);
        return expression;
    }

    public static Expression valueOf(String string) throws ParseException {
        int[] nArray = new int[1];
        Generic generic = (Generic)ExpressionParser.parser.parse(string, nArray);
        Parser.skipWhitespaces(string, nArray);
        if (nArray[0] < string.length()) {
            throw new ParseException();
        }
        Expression expression = new Expression();
        expression.init(generic);
        return expression;
    }

    void init(Expression expression) {
        this.init(expression.size);
        System.arraycopy(expression.literal, 0, this.literal, 0, this.size);
        System.arraycopy(expression.coef, 0, this.coef, 0, this.size);
    }

    void init(JSCLInteger jSCLInteger) {
        this.init(Literal.valueOf(), jSCLInteger);
    }

    void init(Rational rational) {
        try {
            this.init(Literal.valueOf(), rational.integerValue());
        }
        catch (NotIntegerException notIntegerException) {
            this.init(Literal.valueOf(rational.variableValue()), JSCLInteger.valueOf(1L));
        }
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else if (generic instanceof JSCLInteger) {
            this.init(generic.integerValue());
        } else if (generic instanceof Rational) {
            this.init((Rational)generic);
        } else {
            throw new ArithmeticException();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.signum() == 0) {
            stringBuffer.append("0");
        }
        for (int i = 0; i < this.size; ++i) {
            Literal literal = this.literal[i];
            JSCLInteger jSCLInteger = this.coef[i];
            if (jSCLInteger.signum() > 0 && i > 0) {
                stringBuffer.append("+");
            }
            if (literal.degree() == 0) {
                stringBuffer.append(jSCLInteger);
                continue;
            }
            if (jSCLInteger.abs().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                if (jSCLInteger.signum() < 0) {
                    stringBuffer.append("-");
                }
            } else {
                stringBuffer.append(jSCLInteger).append("*");
            }
            stringBuffer.append(literal);
        }
        return stringBuffer.toString();
    }

    @Override
    public String toMathML() {
        String string = "<cn>0</cn>";
        int n = 0;
        for (int i = 0; i < this.size; ++i) {
            String string2;
            Literal literal = this.literal[i];
            JSCLInteger jSCLInteger = this.coef[i];
            Generic generic = jSCLInteger.abs();
            String string3 = literal.degree() == 0 ? generic.toMathML() : (string2 = generic.compareTo(JSCLInteger.valueOf(1L)) == 0 ? literal.toMathML() : "<apply><times/>" + generic.toMathML() + literal.toMathML() + "</apply>");
            string = n == 0 ? (jSCLInteger.signum() < 0 ? "<apply><minus/>" + string2 + "</apply>" : string2) : (jSCLInteger.signum() < 0 ? "<apply><minus/>" + string + string2 + "</apply>" : "<apply><plus/>" + string + string2 + "</apply>");
            ++n;
        }
        return string;
    }

    protected Expression newinstance(int n) {
        return new Expression(n);
    }
}

