/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

class Clifford {
    int p;
    int n;
    int[][] operator;

    Clifford(int[] nArray) {
        this(nArray[0], nArray[1]);
    }

    Clifford(int n, int n2) {
        this.p = n;
        this.n = n + n2;
        int n3 = 1 << this.n;
        this.operator = new int[n3][n3];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n3; ++j) {
                int n4 = Clifford.combination(i, this.n);
                int n5 = Clifford.combination(j, this.n);
                int n6 = n4 ^ n5;
                int n7 = Clifford.location(n6, this.n);
                boolean bl = this.sign(n4, n5);
                int n8 = n7 + 1;
                this.operator[i][j] = bl ? -n8 : n8;
            }
        }
    }

    boolean sign(int n, int n2) {
        boolean bl = false;
        for (int i = 0; i < this.n; ++i) {
            if ((n2 & 1 << i) <= 0) continue;
            for (int j = i; j < this.n; ++j) {
                if ((n & 1 << j) <= 0 || j <= i && i < this.p) continue;
                bl = !bl;
            }
        }
        return bl;
    }

    static int combination(int n, int n2) {
        if (n2 <= 2) {
            return n;
        }
        int[] nArray = new int[1];
        int n3 = Clifford.decimation(n, n2, nArray);
        int n4 = Clifford.combination(n3, n2 - 1);
        return (n4 << 1) + nArray[0];
    }

    static int location(int n, int n2) {
        if (n2 <= 2) {
            return n;
        }
        int n3 = n >> 1;
        int n4 = n & 1;
        int n5 = Clifford.location(n3, n2 - 1);
        return Clifford.dilatation(n5, n2, new int[]{n4});
    }

    static int decimation(int n, int n2, int[] nArray) {
        int n3 = Clifford.grade(n, n2 - 1, 1);
        int n4 = n3 + 1 >> 1;
        nArray[0] = n3 & 1;
        return n - Clifford.sum(n4, n2 - 1);
    }

    static int dilatation(int n, int n2, int[] nArray) {
        int n3 = Clifford.grade(n, n2 - 1);
        return n + Clifford.sum(n3 + nArray[0], n2 - 1);
    }

    static int grade(int n, int n2) {
        return Clifford.grade(n, n2, 0);
    }

    static int grade(int n, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        while ((n4 += Clifford.binomial(n2, n5 >> n3)) <= n) {
            ++n5;
        }
        return n5;
    }

    static int sum(int n, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n3 < n) {
            n4 += Clifford.binomial(n2, n3++);
        }
        return n4;
    }

    static int binomial(int n, int n2) {
        int n3;
        int n4 = 1;
        int n5 = 1;
        for (n3 = n - n2 + 1; n3 <= n; ++n3) {
            n4 *= n3;
        }
        for (n3 = 2; n3 <= n2; ++n3) {
            n5 *= n3;
        }
        return n4 / n5;
    }

    static int log2e(int n) {
        int n2 = 0;
        while (n > 1) {
            ++n2;
            n >>= 1;
        }
        return n2;
    }

    int[][] operator() {
        return this.operator;
    }
}

