/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.threads;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class ThreadUtilities {
    private static Thread consumerThread;
    private static Queue<Runnable> queue;

    public static Thread invoke(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.start();
        return thread;
    }

    public static void invokeQueued(Runnable runnable) {
        if (consumerThread == null) {
            consumerThread = new Thread(new ConsumerThread());
            consumerThread.setDaemon(true);
            consumerThread.setName("background consumer thread");
            consumerThread.start();
        }
        queue.offer(runnable);
    }

    public static boolean invokeAndWait(int maxTimeSec, Runnable runnable) {
        Thread thread = ThreadUtilities.invoke(runnable);
        long stop = System.currentTimeMillis() + (long)(maxTimeSec * 1000);
        while (thread.isAlive() && stop > System.currentTimeMillis()) {
            Thread.yield();
        }
        if (thread.isAlive()) {
            thread.interrupt();
            return false;
        }
        return true;
    }

    static {
        queue = new ConcurrentLinkedQueue<Runnable>();
    }

    private static class ConsumerThread
    implements Runnable {
        private Thread activeThread;

        private ConsumerThread() {
        }

        @Override
        public void run() {
            while (true) {
                if (this.activeThread == null || !this.activeThread.isAlive()) {
                    Runnable poll = (Runnable)queue.poll();
                    if (poll != null) {
                        this.activeThread = ThreadUtilities.invoke(poll);
                    } else {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                Thread.yield();
            }
        }
    }
}

