/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.statistics;

import de.mcs.utils.statistics.ActionCount;
import java.io.File;

public class Count {
    public static int lines = 0;
    public static int realComments = 0;
    public static int realCode = 0;
    public static int fileCount = 0;
    public static int commentsToCode = 0;
    private static final String[] DIRECTORIES = new String[]{"./src", "./test/src", "./webroot"};
    protected static final String[] FILESTOCOUNT = new String[]{".java", ".zul", ".vm"};

    public static String justify(int s) {
        return Count.justify(s, 6);
    }

    public static String justify(int s, int i) {
        String b = "                                         ";
        String n = s + "";
        return b.substring(0, i - n.length()) + n;
    }

    private static void assertCond(boolean cond, String msg) {
        if (!cond) {
            System.out.println("assertCond FAILED: " + msg);
            System.exit(1);
        }
    }

    private static void reset() {
        lines = 0;
        realComments = 0;
        realCode = 0;
        fileCount = 0;
        commentsToCode = 0;
    }

    public static void main(String[] args) {
        ActionCount action = new ActionCount();
        action.prepare();
        for (String directory : DIRECTORIES) {
            Count.reset();
            File d = new File(directory);
            System.out.println("-----------------------------");
            System.out.println("Counting Lines in all files " + d.getPath());
            System.out.println("-----------------------------");
            Count.RecurseDir(action, d, 0);
            action.done();
            if (realCode > 0) {
                commentsToCode = 100 * realComments / realCode;
            }
            System.out.println("-----------------------------");
            System.out.println("Lines:" + Count.justify(lines) + " Cmt=" + Count.justify(realComments) + " Code=" + Count.justify(realCode) + " Ratio=" + Count.justify(commentsToCode) + "% " + " Total files=" + fileCount);
            System.out.println("-----------------------------");
        }
        action.prepare();
    }

    private static void RecurseDir(ActionCount action, File dir, int level) {
        Count.assertCond(level < 100, "no infinite recursion");
        String[] list = dir.list();
        if (list != null) {
            for (int i = 0; i < list.length; ++i) {
                action.exec(dir, list[i]);
                File f = new File(dir, list[i]);
                Count.assertCond(f != null, "f is null");
                Count.assertCond(list[i] != null, "list[i] is null");
                if (!f.isDirectory() || list[i].equals("Backup")) continue;
                Count.RecurseDir(action, f, level + 1);
            }
        }
    }
}

