/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.statistics;

import de.mcs.utils.statistics.Count;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

class ActionCount {
    int lines;
    int realComments;
    int realCode;
    int commentsToCode;
    String name;

    ActionCount() {
    }

    private static void assertCond(boolean cond, String msg) {
        if (!cond) {
            System.out.println("assertCond FAILED: " + msg);
            System.exit(1);
        }
    }

    public static String justify(int s) {
        return ActionCount.justify(s, 6);
    }

    public static String justify(int s, int i) {
        String b = "                                         ";
        String n = s + "";
        return b.substring(0, i - n.length()) + n;
    }

    public void prepare() {
    }

    public void done() {
    }

    public void exec(File dir, String filename) {
        boolean proceed = false;
        for (String type : Count.FILESTOCOUNT) {
            if (!filename.endsWith(type)) continue;
            proceed = true;
        }
        if (!proceed || filename.equals("Count.java")) {
            return;
        }
        this.lines = 0;
        this.realComments = 0;
        this.realCode = 0;
        File filein = new File(dir, filename);
        this.name = filein.toString();
        this.convert(filein.toString());
        this.commentsToCode = this.realCode == 0 ? 1000 : 100 * this.realComments / this.realCode;
        System.out.println("Lines:" + ActionCount.justify(this.lines) + " Cmt=" + ActionCount.justify(this.realComments) + " Code=" + ActionCount.justify(this.realCode) + " Ratio=" + ActionCount.justify(this.commentsToCode) + "% " + this.name);
        Count.lines += this.lines;
        Count.realComments += this.realComments;
        Count.realCode += this.realCode;
        Count.commentsToCode += this.commentsToCode;
        ++Count.fileCount;
    }

    private void countLine(String line) {
        if (line.indexOf("/**") > 0) {
            if (line.trim().length() > 3) {
                ++this.realComments;
            }
            return;
        }
        if (line.indexOf("*") > 0 && line.trim().length() > 3) {
            ++this.realComments;
            return;
        }
        if (line.trim().indexOf("/*") == 1 && line.indexOf("*/") > 0) {
            ++this.realComments;
            return;
        }
        if (line.indexOf("*/") > 0) {
            return;
        }
        int pos = line.indexOf("//");
        if (pos >= 0) {
            String t = line.substring(pos + 2).trim();
            if (t.length() > 0) {
                ++this.realComments;
                return;
            }
        } else {
            String t = line.trim();
            if (t.length() > 3) {
                ++this.realCode;
                return;
            }
        }
    }

    public void convert(String filename) {
        FileInputStream inputStream = null;
        String line = null;
        try {
            inputStream = new FileInputStream(filename);
        }
        catch (Exception e) {
            ActionCount.assertCond(false, "File not readable " + filename);
        }
        BufferedReader file = new BufferedReader(new InputStreamReader(inputStream));
        while (true) {
            try {
                line = file.readLine();
                ++this.lines;
            }
            catch (Exception e) {
                ActionCount.assertCond(false, "File not readable " + filename);
            }
            if (line == null) break;
            this.countLine(line);
        }
        try {
            file.close();
        }
        catch (Exception e) {
            ActionCount.assertCond(false, "File not closeable " + filename);
        }
    }
}

