/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.nio;

import de.mcs.utils.nio.WatchCallBack;
import de.mcs.utils.nio.WatchDir;
import java.io.IOException;
import java.nio.file.Path;

public class WatchDirThread
extends Thread {
    private Path watchDir;
    private WatchDir watcher;
    private WatchCallBack callback;
    private boolean enable;
    private boolean recursive;

    public WatchDirThread(WatchCallBack callback, Path watchDir, boolean recursive) throws IOException {
        this.watchDir = watchDir;
        this.callback = callback;
        this.recursive = recursive;
        this.setEnable(true);
        this.setDaemon(true);
    }

    @Override
    public void run() {
        try {
            this.watcher = new WatchDir(this.watchDir, this.recursive);
            while (!this.isInterrupted()) {
                if (this.isEnable()) {
                    this.watcher.processEvents(this.callback);
                } else {
                    this.watcher.processEvents(new WatchCallBack(){

                        @Override
                        public void modified(Path path) {
                        }
                    });
                }
                Thread.yield();
            }
            this.watcher.remove();
            this.watcher = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }
}

