/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.nio;

import de.mcs.utils.nio.WatchCallBack;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashMap;
import java.util.Map;

public class WatchDir {
    private WatchService watcher = FileSystems.getDefault().newWatchService();
    private final Map<WatchKey, Path> keys = new HashMap<WatchKey, Path>();
    private final boolean recursive;
    private boolean trace = false;
    private Thread fileSystemPoller;

    static <T> WatchEvent<T> cast(WatchEvent<?> event) {
        return event;
    }

    private void register(Path dir) throws IOException {
        Path prev;
        WatchKey key = dir.register(this.watcher, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY);
        if (!this.trace || (prev = this.keys.get(key)) == null || !dir.equals(prev)) {
            // empty if block
        }
        this.keys.put(key, dir);
    }

    private void registerAll(Path start) throws IOException {
        Files.walkFileTree(start, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                if (dir.toFile().getName().startsWith(".")) {
                    return FileVisitResult.SKIP_SUBTREE;
                }
                WatchDir.this.register(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }

    public WatchDir(Path dir, boolean recursive) throws IOException {
        this.recursive = recursive;
        if (recursive) {
            this.registerAll(dir);
        } else {
            this.register(dir);
        }
        this.trace = true;
    }

    public void startWatchThread(final WatchCallBack callback) throws InterruptedException {
        if (this.fileSystemPoller != null && this.fileSystemPoller.isAlive()) {
            this.fileSystemPoller.interrupt();
            this.fileSystemPoller.join();
        }
        this.fileSystemPoller = new Thread(new Runnable(){

            @Override
            public void run() {
                while (!WatchDir.this.fileSystemPoller.isInterrupted()) {
                    WatchDir.this.processEvents(callback);
                }
            }
        }, "filesystempoller");
        this.fileSystemPoller.setDaemon(true);
        this.fileSystemPoller.start();
    }

    public void stopWatchThread() throws InterruptedException {
        if (this.fileSystemPoller != null) {
            if (this.fileSystemPoller.isAlive()) {
                this.fileSystemPoller.interrupt();
                this.fileSystemPoller.join();
            }
            this.fileSystemPoller = null;
        }
    }

    public boolean isActive() {
        return this.fileSystemPoller != null && this.fileSystemPoller.isAlive();
    }

    public void processEvents(WatchCallBack callback) {
        while (true) {
            WatchKey key;
            if ((key = this.watcher.poll()) == null) {
                return;
            }
            Path dir = this.keys.get(key);
            if (dir == null) continue;
            for (WatchEvent<?> event : key.pollEvents()) {
                WatchEvent.Kind<?> kind = event.kind();
                if (kind == StandardWatchEventKinds.OVERFLOW) continue;
                WatchEvent ev = WatchDir.cast(event);
                Path name = (Path)ev.context();
                Path child = dir.resolve(name);
                if (callback != null) {
                    callback.modified(child);
                }
                if (!this.recursive || kind != StandardWatchEventKinds.ENTRY_CREATE) continue;
                try {
                    if (!Files.isDirectory(child, LinkOption.NOFOLLOW_LINKS)) continue;
                    this.registerAll(child);
                }
                catch (IOException x) {}
            }
            boolean valid = key.reset();
            if (valid) continue;
            this.keys.remove(key);
            if (this.keys.isEmpty()) break;
        }
    }

    static void usage() {
        System.err.println("usage: java WatchDir [-r] dir");
        System.exit(-1);
    }

    public static void main(String[] args) throws IOException {
        if (args.length == 0 || args.length > 2) {
            WatchDir.usage();
        }
        boolean recursive = false;
        int dirArg = 0;
        if (args[0].equals("-r")) {
            if (args.length < 2) {
                WatchDir.usage();
            }
            recursive = true;
            ++dirArg;
        }
        Path dir = Paths.get(args[dirArg], new String[0]);
        new WatchDir(dir, recursive).processEvents(null);
    }

    public void remove() throws IOException {
        if (this.watcher != null) {
            this.watcher.close();
            this.watcher = null;
        }
    }
}

