/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public class RandomAccessInputStream
extends InputStream {
    private RandomAccessFile raf = null;
    private long markpos = -1L;
    private boolean sympathyClose;

    public RandomAccessInputStream(RandomAccessFile raf) throws IOException {
        this(raf, false, 0L);
    }

    public RandomAccessInputStream(File file) throws IOException {
        this(new RandomAccessFile(file, "r"), true, 0L);
    }

    public RandomAccessInputStream(File file, long offset) throws IOException {
        this(new RandomAccessFile(file, "r"), true, offset);
    }

    public RandomAccessInputStream(RandomAccessFile raf, boolean sympathyClose, long offset) throws IOException {
        this.sympathyClose = sympathyClose;
        this.raf = raf;
        if (offset > 0L) {
            this.raf.seek(offset);
        }
    }

    @Override
    public int read() throws IOException {
        return this.raf.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.raf.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.raf.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        this.raf.seek(this.raf.getFilePointer() + n);
        return n;
    }

    public long position() throws IOException {
        return this.raf.getFilePointer();
    }

    public void position(long position) throws IOException {
        this.raf.seek(position);
    }

    @Override
    public int available() throws IOException {
        long amount = this.raf.length() - this.position();
        return amount >= Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)amount;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public synchronized void mark(int readlimit) {
        try {
            this.markpos = this.position();
        }
        catch (IOException e) {
            this.markpos = -1L;
        }
    }

    @Override
    public synchronized void reset() throws IOException {
        if (this.markpos == -1L) {
            throw new IOException("Mark has not been set.");
        }
        this.position(this.markpos);
    }

    @Override
    public void close() throws IOException {
        if (this.sympathyClose) {
            this.raf.close();
        }
    }
}

