/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.event;

import de.mcs.utils.event.AbstractEvent;
import de.mcs.utils.event.CallbackList;
import de.mcs.utils.event.Delegate;
import de.mcs.utils.event.EventListener;
import java.util.List;

public class ManagedProperty<E>
implements CallbackList.ListCallback {
    private E value;
    private Delegate delegate;
    private ManagedEvent event;
    private boolean fireEventActive;

    public ManagedProperty(String name, Delegate delegate, E initialValue) {
        this.value = initialValue;
        this.delegate = delegate;
        this.fireEventActive = true;
        this.event = new ManagedEvent(name);
        delegate.registerEvent(this.event);
        if (this.value instanceof List) {
            List initialList = (List)this.value;
            CallbackList list = new CallbackList(initialList);
            list.addCallback(this);
            this.value = list;
        }
    }

    public void setValue(E newValue) {
        this.setValue(newValue, true);
    }

    public void setValue(E newValue, boolean fireEvent) {
        if (this.value != null) {
            if (!this.value.equals(newValue)) {
                E oldValue = this.value;
                this.value = newValue;
                if (fireEvent) {
                    this.delegate.fireEvent(this.event, new Object[]{oldValue, newValue});
                }
            }
        } else if (newValue != null) {
            this.value = newValue;
            if (fireEvent) {
                this.delegate.fireEvent(this.event, new Object[]{this.value, newValue});
            }
        }
    }

    public void fireEvent() {
        if (this.fireEventActive) {
            this.delegate.fireEvent(this.event, new Object[]{this.value, this.value});
        }
    }

    public E getValue() {
        return this.value;
    }

    public void registerListener(EventListener listener) {
        this.delegate.registerListener(this.event, listener);
    }

    public void unregisterListener(EventListener listener) {
        this.delegate.unregisterListener(this.event, listener);
    }

    @Override
    public void handle(CallbackList.Operation operation) {
        if (this.fireEventActive) {
            this.delegate.fireEvent(this.event, new Object[]{operation.name()});
        }
    }

    public void setFireEvents(boolean value) {
        this.fireEventActive = value;
    }

    public boolean isFireEvents() {
        return this.fireEventActive;
    }

    public class ManagedEvent
    extends AbstractEvent {
        ManagedEvent(String name) {
            super(name);
        }
    }
}

