/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.event;

import de.mcs.utils.event.Event;
import de.mcs.utils.event.EventListener;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class EventFactory {
    private static EventFactory instance = new EventFactory();
    private Map<String, List<WeakReference<EventListener>>> events = new HashMap<String, List<WeakReference<EventListener>>>();
    private List<WeakReference<EventListener>> generalListeners = new ArrayList<WeakReference<EventListener>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerEvent(Event event) {
        Map<String, List<WeakReference<EventListener>>> map = this.events;
        synchronized (map) {
            if (!this.events.containsKey(event.getName())) {
                this.events.put(event.getName(), new ArrayList());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerListener(Event event, EventListener eventListener) {
        List<WeakReference<EventListener>> list = null;
        Object object = this.events;
        synchronized (object) {
            if (this.events.containsKey(event.getName())) {
                list = this.events.get(event.getName());
            }
        }
        if (list != null) {
            object = list;
            synchronized (object) {
                Iterator<WeakReference<EventListener>> iter = list.iterator();
                while (iter.hasNext()) {
                    WeakReference<EventListener> listener = iter.next();
                    if (listener.isEnqueued()) {
                        iter.remove();
                        continue;
                    }
                    if (!eventListener.equals(listener.get())) continue;
                    return;
                }
                WeakReference<EventListener> weakEventListener = new WeakReference<EventListener>(eventListener);
                list.add(weakEventListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterListener(Event event, EventListener eventListener) {
        List<WeakReference<EventListener>> list = null;
        Object object = this.events;
        synchronized (object) {
            if (this.events.containsKey(event.getName())) {
                list = this.events.get(event.getName());
            }
        }
        if (list != null) {
            object = list;
            synchronized (object) {
                Iterator<WeakReference<EventListener>> iter = list.iterator();
                while (iter.hasNext()) {
                    WeakReference<EventListener> listener = iter.next();
                    if (listener.isEnqueued()) {
                        iter.remove();
                        continue;
                    }
                    if (!eventListener.equals(listener.get())) continue;
                    iter.remove();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireEvent(Event event, Object ... data) {
        WeakReference<EventListener> weakListener;
        Iterator<WeakReference<EventListener>> iter;
        List<WeakReference<EventListener>> list = null;
        List<WeakReference<EventListener>> list2 = this.events;
        synchronized (list2) {
            if (this.events.containsKey(event.getName())) {
                list = this.events.get(event.getName());
            }
        }
        if (list != null) {
            list2 = list;
            synchronized (list2) {
                iter = list.iterator();
                while (iter.hasNext()) {
                    weakListener = iter.next();
                    if (weakListener.isEnqueued()) {
                        iter.remove();
                        continue;
                    }
                    if (weakListener.get() == null) {
                        iter.remove();
                        continue;
                    }
                    ((EventListener)weakListener.get()).handle(event.getName(), data);
                }
            }
        }
        list2 = this.generalListeners;
        synchronized (list2) {
            iter = this.generalListeners.iterator();
            while (iter.hasNext()) {
                weakListener = iter.next();
                if (weakListener.isEnqueued()) {
                    iter.remove();
                    continue;
                }
                if (weakListener.get() == null) {
                    iter.remove();
                    continue;
                }
                ((EventListener)weakListener.get()).handle(event.getName(), data);
            }
        }
    }

    public boolean isEventRegistered(Event event1) {
        return this.events.containsKey(event1.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isListenerRegistered(Event event, EventListener eventListener) {
        List<WeakReference<EventListener>> list = null;
        Object object = this.events;
        synchronized (object) {
            if (this.events.containsKey(event.getName())) {
                list = this.events.get(event.getName());
            }
        }
        if (list != null) {
            object = list;
            synchronized (object) {
                Iterator<WeakReference<EventListener>> iter = list.iterator();
                while (iter.hasNext()) {
                    WeakReference<EventListener> listener = iter.next();
                    if (listener.isEnqueued()) {
                        iter.remove();
                        continue;
                    }
                    if (!eventListener.equals(listener.get())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static EventFactory getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerGeneralListener(EventListener eventListener) {
        List<WeakReference<EventListener>> list = this.generalListeners;
        synchronized (list) {
            Iterator<WeakReference<EventListener>> iter = this.generalListeners.iterator();
            while (iter.hasNext()) {
                WeakReference<EventListener> listener = iter.next();
                if (listener.isEnqueued()) {
                    iter.remove();
                    continue;
                }
                if (!eventListener.equals(listener.get())) continue;
                return;
            }
            WeakReference<EventListener> weakEventListener = new WeakReference<EventListener>(eventListener);
            this.generalListeners.add(weakEventListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterGeneralListener(EventListener eventListener) {
        List<WeakReference<EventListener>> list = this.generalListeners;
        synchronized (list) {
            Iterator<WeakReference<EventListener>> iter = this.generalListeners.iterator();
            while (iter.hasNext()) {
                WeakReference<EventListener> listener = iter.next();
                if (listener.isEnqueued()) {
                    iter.remove();
                    continue;
                }
                if (!eventListener.equals(listener.get())) continue;
                iter.remove();
            }
        }
    }
}

