/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.event;

import java.lang.ref.WeakReference;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class CallbackList<E>
extends AbstractList<E>
implements List<E> {
    private List<WeakReference<ListCallback>> callbackList = new ArrayList<WeakReference<ListCallback>>();
    private List<E> list = null;

    public CallbackList() {
        this.list = new ArrayList();
    }

    public CallbackList(List<E> list) {
        this.list = list;
    }

    public void addCallback(ListCallback listCallback) {
        Iterator<WeakReference<ListCallback>> iter = this.callbackList.iterator();
        while (iter.hasNext()) {
            WeakReference<ListCallback> listener = iter.next();
            if (listener.isEnqueued()) {
                iter.remove();
                continue;
            }
            if (!listCallback.equals(listener.get())) continue;
            return;
        }
        WeakReference<ListCallback> weakEventListener = new WeakReference<ListCallback>(listCallback);
        this.callbackList.add(weakEventListener);
    }

    public void removeCallback(ListCallback listCallback) {
        Iterator<WeakReference<ListCallback>> iter = this.callbackList.iterator();
        while (iter.hasNext()) {
            WeakReference<ListCallback> listener = iter.next();
            if (listener.isEnqueued()) {
                iter.remove();
                continue;
            }
            if (!listCallback.equals(listener.get())) continue;
            iter.remove();
        }
    }

    @Override
    public E get(int index) {
        return this.list.get(index);
    }

    @Override
    public int size() {
        return this.list.size();
    }

    @Override
    public void add(int index, E element) {
        this.list.add(index, element);
        this.fireCallback(Operation.add);
    }

    public void fireCallback(Operation operation) {
        Iterator<WeakReference<ListCallback>> iter = this.callbackList.iterator();
        while (iter.hasNext()) {
            WeakReference<ListCallback> weakListener = iter.next();
            if (weakListener.isEnqueued()) {
                iter.remove();
                continue;
            }
            if (weakListener.get() == null) {
                iter.remove();
                continue;
            }
            ((ListCallback)weakListener.get()).handle(operation);
        }
    }

    @Override
    public E remove(int index) {
        E remove = this.list.remove(index);
        this.fireCallback(Operation.remove);
        return remove;
    }

    @Override
    public void clear() {
        this.list.clear();
        this.fireCallback(Operation.clear);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean addAll = this.list.addAll(index, c);
        this.fireCallback(Operation.addall);
        return addAll;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        boolean addAll = this.list.addAll(c);
        this.fireCallback(Operation.addall);
        return addAll;
    }

    public static interface ListCallback {
        public void handle(Operation var1);
    }

    public static enum Operation {
        add,
        addall,
        remove,
        clear;

    }
}

