/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.codecs;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class Base64Decoder {
    private static final int BUFFER_SIZE = 1024;
    private String encoding = null;
    private InputStream in = null;
    private OutputStream out = null;
    private boolean stringp = false;

    public static byte[] decode(String string) throws Exception {
        ByteArrayInputStream bin = new ByteArrayInputStream(string.getBytes());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Base64Decoder myDecode = new Base64Decoder(bin, bout);
        myDecode.process();
        return bout.toByteArray();
    }

    private int get1(byte[] buf, int off) {
        return (buf[off] & 0x3F) << 2 | (buf[off + 1] & 0x30) >>> 4;
    }

    private int get2(byte[] buf, int off) {
        return (buf[off + 1] & 0xF) << 4 | (buf[off + 2] & 0x3C) >>> 2;
    }

    private int get3(byte[] buf, int off) {
        return (buf[off + 2] & 3) << 6 | buf[off + 3] & 0x3F;
    }

    private int check(int ch) {
        if (ch >= 65 && ch <= 90) {
            return ch - 65;
        }
        if (ch >= 97 && ch <= 122) {
            return ch - 97 + 26;
        }
        if (ch >= 48 && ch <= 57) {
            return ch - 48 + 52;
        }
        switch (ch) {
            case 61: {
                return 65;
            }
            case 43: {
                return 62;
            }
            case 47: {
                return 63;
            }
        }
        return -1;
    }

    public final void process() throws Exception {
        byte[] buffer = new byte[1024];
        byte[] chunk = new byte[4];
        int got = -1;
        int ready = 0;
        block0: while ((got = this.in.read(buffer)) > 0) {
            int skiped = 0;
            while (skiped < got) {
                while (ready < 4) {
                    int ch;
                    if (skiped >= got) continue block0;
                    if ((ch = this.check(buffer[skiped++])) < 0) continue;
                    chunk[ready++] = (byte)ch;
                }
                if (chunk[2] == 65) {
                    this.out.write(this.get1(chunk, 0));
                    return;
                }
                if (chunk[3] == 65) {
                    this.out.write(this.get1(chunk, 0));
                    this.out.write(this.get2(chunk, 0));
                    return;
                }
                this.out.write(this.get1(chunk, 0));
                this.out.write(this.get2(chunk, 0));
                this.out.write(this.get3(chunk, 0));
                ready = 0;
            }
        }
        if (ready != 0) {
            throw new Exception("Invalid length.");
        }
        this.out.flush();
    }

    public final String processString() {
        String s;
        if (!this.stringp) {
            throw new RuntimeException(this.getClass().getName() + "[processString]" + "invalid call (not a String)");
        }
        try {
            this.process();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            s = ((ByteArrayOutputStream)this.out).toString(this.encoding);
        }
        catch (Exception ex) {
            throw new RuntimeException(this.getClass().getName() + "[processString] Unable to convert" + "properly char to bytes");
        }
        return s;
    }

    public Base64Decoder(String input) {
        this(input, null);
    }

    public Base64Decoder(String input, String sEncoding) {
        byte[] bytes;
        String myEncoding = sEncoding;
        if (myEncoding == null) {
            myEncoding = "ISO-8859-1";
        }
        try {
            bytes = input.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException(this.getClass().getName() + "[Constructor] Unable to convert" + "properly char to bytes");
        }
        this.stringp = true;
        this.in = new ByteArrayInputStream(bytes);
        this.encoding = myEncoding;
        this.out = new ByteArrayOutputStream();
    }

    public Base64Decoder(InputStream isIn, OutputStream isOut) {
        this.in = isIn;
        this.out = isOut;
        this.stringp = false;
    }

    public static void main(String[] args) {
        if (args.length == 1) {
            try {
                Base64Decoder b = new Base64Decoder(args[0]);
                System.out.println("[" + b.processString() + "]");
            }
            catch (RuntimeException e) {
                System.out.println("Invalid Base64 format !");
                System.exit(1);
            }
        } else if (args.length == 2 && args[0].equals("-f")) {
            try {
                FileInputStream in = new FileInputStream(args[1]);
                Base64Decoder b = new Base64Decoder(in, System.out);
                b.process();
            }
            catch (Exception ex) {
                System.out.println("error: " + ex.getMessage());
                System.exit(1);
            }
        } else {
            System.out.println("Base64Decoder [strong] [-f file]");
        }
        System.exit(0);
    }
}

