/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.caches;

import de.mcs.utils.caches.KeyAlreadyExistsException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;

public class ObjectCache<E> {
    private Map<String, CacheItem<E>> objectMap = null;
    private Map<String, String> objectMapExternal = null;
    private int maxCount;
    private Timer timer = null;
    private ObjectListener<E> objectListener = null;
    private Comparator<? super CacheItem<E>> comperator = new Comparator<CacheItem<E>>(){

        @Override
        public int compare(CacheItem<E> o1, CacheItem<E> o2) {
            try {
                int cmp = 0;
                if (o1 == null && o2 == null) {
                    cmp = 0;
                } else if (o1 == null) {
                    cmp = -1;
                } else if (o2 == null) {
                    cmp = 1;
                } else {
                    Long d1 = o1.getAccess();
                    Long d2 = o2.getAccess();
                    cmp = d1.compareTo(d2);
                }
                return cmp;
            }
            catch (Exception e) {
                e.printStackTrace();
                return 0;
            }
        }
    };

    public ObjectCache() {
        this(-1);
    }

    public ObjectCache(int maxCount) {
        int size;
        this.maxCount = maxCount;
        int n = size = maxCount > 0 ? maxCount : 1000;
        if (maxCount >= 0) {
            this.objectMap = new HashMap<String, CacheItem<E>>(size, 100.0f);
            this.objectMapExternal = new HashMap<String, String>(size, 100.0f);
        } else {
            this.objectMap = new HashMap<String, CacheItem<E>>();
            this.objectMapExternal = new HashMap<String, String>();
        }
        this.initCache();
    }

    private void initCache() {
    }

    public final String addObject(E object) {
        try {
            return this.addObject(null, object);
        }
        catch (KeyAlreadyExistsException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String addObject(String externalKey, E object) throws KeyAlreadyExistsException {
        if (externalKey != null && this.hasExternalKey(externalKey)) {
            throw new KeyAlreadyExistsException("the external key is already in use.");
        }
        CacheItem<E> cacheItem = new CacheItem<E>(object, externalKey);
        if (!this.hasObject(((CacheItem)cacheItem).sID)) {
            this.checkSize();
            Map<String, CacheItem<E>> map = this.objectMap;
            synchronized (map) {
                this.objectMap.put(((CacheItem)cacheItem).sID, cacheItem);
                if (externalKey != null) {
                    this.objectMapExternal.put(externalKey, ((CacheItem)cacheItem).sID);
                }
            }
        }
        return ((CacheItem)cacheItem).sID;
    }

    private void checkSize() {
        if (this.maxCount > 0) {
            while (this.objectMap.size() >= this.maxCount) {
                this.removeOldest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeOldest() {
        ArrayList<CacheItem<E>> list = null;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            list = new ArrayList<CacheItem<E>>(this.objectMap.values());
            Comparator<? super CacheItem<E>> comparator = this.comperator;
            synchronized (comparator) {
                Collections.sort(list, this.comperator);
            }
            CacheItem item = (CacheItem)list.get(0);
            this.removeObject(item.sID);
        }
    }

    public final boolean hasObject(String objectID) {
        boolean hasId = false;
        hasId = this.objectMap.containsKey(objectID);
        return hasId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasExternalKey(String externalKey) {
        boolean hasId = false;
        Map<String, String> map = this.objectMapExternal;
        synchronized (map) {
            hasId = this.objectMapExternal.containsKey(externalKey);
        }
        return hasId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getIDfromExternalKey(String externalKey) {
        String objectId = null;
        Map<String, String> map = this.objectMapExternal;
        synchronized (map) {
            if (this.objectMapExternal.containsKey(externalKey)) {
                objectId = this.objectMapExternal.get(externalKey);
            }
        }
        return objectId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private E getObjectInternal(String objectID) {
        Object object = null;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            if (this.hasObject(objectID)) {
                CacheItem<E> cacheItem = this.objectMap.get(objectID);
                object = ((CacheItem)cacheItem).object;
            }
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E getObject(String objectID) {
        Object object = null;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            if (this.hasObject(objectID)) {
                CacheItem<E> cacheItem = this.objectMap.get(objectID);
                cacheItem.setAccess();
                object = ((CacheItem)cacheItem).object;
            }
        }
        return (E)object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E getOldestObject() {
        Object object = null;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            ArrayList<CacheItem<E>> list = new ArrayList<CacheItem<E>>(this.objectMap.values());
            Comparator<? super CacheItem<E>> comparator = this.comperator;
            synchronized (comparator) {
                Collections.sort(list, this.comperator);
            }
            if (list.size() == 0) {
                return null;
            }
            CacheItem cacheItem = (CacheItem)list.get(0);
            cacheItem.setAccess();
            object = cacheItem.object;
            return (E)object;
        }
    }

    public final E getObjectFromExternalKey(String externalKey) {
        E object = null;
        String objectID = this.getIDfromExternalKey(externalKey);
        if (objectID != null) {
            return this.getObject(objectID);
        }
        return object;
    }

    public void touchExternalKey(String externalKey) {
        String objectID = this.getIDfromExternalKey(externalKey);
        if (objectID != null) {
            this.getObject(objectID);
        }
    }

    public void touch(String objectID) {
        this.getObject(objectID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final E removeObject(String objectID) {
        Object object = null;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            CacheItem<E> cacheItem;
            if (this.hasObject(objectID) && (cacheItem = this.objectMap.remove(objectID)) != null) {
                if (this.objectMapExternal.containsKey(cacheItem.getExternalKey())) {
                    this.objectMapExternal.remove(cacheItem.getExternalKey());
                }
                object = ((CacheItem)cacheItem).object;
                if (this.objectListener != null) {
                    this.objectListener.onDelete(cacheItem.getObject());
                }
            }
        }
        return (E)object;
    }

    public final E removeObjectFromExternalKey(String externalKey) {
        E object = null;
        String objectID = this.getIDfromExternalKey(externalKey);
        if (objectID != null) {
            return this.removeObject(objectID);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void freeObjects(long sec) {
        Iterator<Object> it;
        Date myEqualDate = new Date(new Date().getTime() - sec * 1000L);
        ArrayList<String> vDelKeys = new ArrayList<String>(this.objectMap.size());
        String sKey2 = "";
        Map<String, Object> map = this.objectMap;
        synchronized (map) {
            for (String sKey2 : this.objectMap.keySet()) {
                CacheItem<E> cacheItem = this.objectMap.get(sKey2);
                if (myEqualDate.getTime() <= cacheItem.getAccess()) continue;
                cacheItem.freeResources();
                vDelKeys.add(sKey2);
            }
            it = null;
            for (int n = 0; n < vDelKeys.size(); ++n) {
                CacheItem<E> item = this.objectMap.remove(vDelKeys.get(n));
                if (this.objectListener == null) continue;
                this.objectListener.onDelete(item.getObject());
            }
            vDelKeys = null;
        }
        map = this.objectMapExternal;
        synchronized (map) {
            it = this.objectMapExternal.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (this.hasObject((String)entry.getValue())) continue;
                it.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getCacheCount() {
        int size;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            size = this.objectMap.size();
        }
        return size;
    }

    public final void freeResources() {
        this.freeObjects(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getObjectIDs() {
        String[] keys;
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            keys = new String[this.objectMap.size()];
            Iterator<String> it = this.objectMap.keySet().iterator();
            int n = 0;
            while (it.hasNext()) {
                keys[n] = it.next();
                ++n;
            }
            Object var3_3 = null;
        }
        return keys;
    }

    public void startCleanupTask(final int cleanupTime, String taskName) {
        if (this.timer != null) {
            this.stopCleanupTask();
        }
        if (this.timer == null) {
            this.timer = new Timer(taskName, true);
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    ObjectCache.this.freeObjects(cleanupTime);
                }
            }, cleanupTime * 1000, (long)(cleanupTime * 1000));
        }
    }

    public void stopCleanupTask() {
        if (this.timer != null) {
            this.timer.cancel();
            this.timer = null;
        }
    }

    public void registerObjectListener(ObjectListener<E> listener) {
        this.objectListener = listener;
    }

    public void removeObjectListener() {
        this.objectListener = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<E> values() {
        ArrayList<E> vs = new ArrayList<E>(this.objectMap.size());
        Map<String, CacheItem<E>> map = this.objectMap;
        synchronized (map) {
            for (CacheItem<E> cacheItem : this.objectMap.values()) {
                vs.add(cacheItem.getObject());
            }
        }
        return vs;
    }

    public static void main(String[] args) throws InterruptedException {
        ObjectCache<Integer> cache = new ObjectCache<Integer>(10);
        for (int i = 0; i < 20; ++i) {
            System.out.print(i + ":" + cache.getCacheCount() + ":");
            for (String string : cache.getObjectIDs()) {
                System.out.print(super.getObjectInternal(string));
                System.out.print(",");
            }
            System.out.println();
            try {
                cache.addObject(Integer.toString(i), new Integer(i));
            }
            catch (KeyAlreadyExistsException e) {
                e.printStackTrace();
            }
            Thread.sleep(1000L);
        }
    }

    class CacheItem<E>
    implements Serializable {
        private static final long serialVersionUID = -871711242126446479L;
        private String sID = UUID.randomUUID().toString();
        private Date dAccess = new Date();
        private String externalKey;
        private E object;

        public CacheItem() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getAccess() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                if (this.dAccess != null) {
                    return this.dAccess.getTime();
                }
                return 0L;
            }
        }

        public CacheItem(E object, String externalKey) {
            this();
            this.object = object;
            this.externalKey = externalKey;
        }

        public void freeResources() {
        }

        protected void finalize() {
            this.freeResources();
        }

        public E getObject() {
            return this.object;
        }

        public String getExternalKey() {
            return this.externalKey;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("object:");
            buffer.append(this.object.toString());
            buffer.append(",ID:");
            buffer.append(this.sID);
            return buffer.toString();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setAccess() {
            CacheItem cacheItem = this;
            synchronized (cacheItem) {
                this.dAccess = new Date();
            }
        }
    }

    public static interface ObjectListener<E> {
        public void onDelete(E var1);
    }
}

