/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.caches;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.util.Properties;

public class FolderBlocker {
    private File messFile;
    private RandomAccessFile fosdirlock;
    private FileLock lock;

    public FolderBlocker(File path, boolean block) throws IOException {
        this.messFile = new File(path, "Don't_mess_with_this_files.txt");
        if (!this.messFile.exists()) {
            Properties messProps = new Properties();
            try {
                messProps.store(new FileOutputStream(this.messFile), "Don't mess with this files");
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (block) {
            try {
                File dirLock = new File(path, ".dirlock");
                this.fosdirlock = new RandomAccessFile(dirLock, "rws");
                FileChannel f = this.fosdirlock.getChannel();
                this.lock = f.tryLock();
                if (this.lock == null) {
                    throw new OverlappingFileLockException();
                }
                dirLock.deleteOnExit();
                ByteBuffer bytes = ByteBuffer.allocate(8);
                bytes.putLong(System.currentTimeMillis() + 10000L).flip();
                f.write(bytes);
                f.force(false);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void freeResources() {
        if (this.fosdirlock != null) {
            try {
                if (this.lock != null && this.lock.isValid()) {
                    this.lock.release();
                }
                this.fosdirlock.close();
                this.fosdirlock = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.freeResources();
    }
}

