/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils.caches;

import de.mcs.utils.Files;
import de.mcs.utils.StringUtils;
import de.mcs.utils.caches.FolderBlocker;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class BlobCache {
    private HashMap<String, BlobCacheItem> hmBlobs = null;
    private HashMap<String, String> hmExternal = null;
    private final int MAXFILECOUNT = 2000;
    private ArrayList<CacheFolder> folders;
    private File blobPath;
    private CacheFolder actualFolder;
    private CacheFolder folder;
    private boolean subfolders;

    public BlobCache(String blobCachePath, boolean useSubFolders) throws IOException {
        this.blobPath = new File(blobCachePath);
        this.hmBlobs = new HashMap(1000, 100.0f);
        this.hmExternal = new HashMap(100, 100.0f);
        this.subfolders = useSubFolders;
        this.initBlobCache();
    }

    public BlobCache(File cachePath, boolean useSubFolders) throws IOException {
        this.blobPath = cachePath;
        this.hmBlobs = new HashMap(1000, 100.0f);
        this.hmExternal = new HashMap(100, 100.0f);
        this.subfolders = useSubFolders;
        this.initBlobCache();
    }

    private void initBlobCache() throws IOException {
        if (!this.blobPath.exists()) {
            this.blobPath.mkdirs();
        }
        new FolderBlocker(this.blobPath, true);
        if (this.subfolders) {
            this.folders = new ArrayList(10);
            this.addCacheFolder();
        }
    }

    private CacheFolder addCacheFolder() throws IOException {
        CacheFolder folder = new CacheFolder(this.blobPath, this.folders.size(), 2000);
        this.folders.add(folder);
        return folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getNewBlobName(String prefix, String suffix) throws IOException {
        String fileName = "";
        if (!this.subfolders) {
            fileName = Files.getTempFileName(prefix, suffix, this.blobPath.getCanonicalPath());
        } else {
            ArrayList<CacheFolder> arrayList = this.folders;
            synchronized (arrayList) {
                if (this.actualFolder == null || !this.actualFolder.canCreate()) {
                    this.actualFolder = null;
                    for (CacheFolder this.folder : this.folders) {
                        if (!this.folder.canCreate()) continue;
                        this.actualFolder = this.folder;
                    }
                    if (this.actualFolder == null) {
                        this.actualFolder = this.addCacheFolder();
                    }
                }
                fileName = this.actualFolder.getNewBlobName(prefix, suffix);
            }
        }
        if (fileName == null || fileName.equals("")) {
            throw new IOException("can't create a new filename.");
        }
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String registerBlob(String blobName) {
        BlobCacheItem myBlob = new BlobCacheItem(blobName, null);
        if (!this.hasBlob(myBlob.sID)) {
            HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
            synchronized (hashMap) {
                this.hmBlobs.put(myBlob.sID, myBlob);
            }
        }
        return myBlob.sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String registerBlob(String blobName, String externalKey) throws KeyAlreadyExistsException {
        if (this.hasExternalKey(externalKey)) {
            throw new KeyAlreadyExistsException("the extrnal key is already in use.");
        }
        BlobCacheItem myBlob = new BlobCacheItem(blobName, externalKey);
        if (!this.hasBlob(myBlob.sID)) {
            HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
            synchronized (hashMap) {
                this.hmBlobs.put(myBlob.sID, myBlob);
                if (externalKey != null) {
                    this.hmExternal.put(externalKey, myBlob.sID);
                }
            }
        }
        return myBlob.sID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasBlob(String blobID) {
        boolean hasId;
        HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
        synchronized (hashMap) {
            hasId = this.hmBlobs.containsKey(blobID);
        }
        return hasId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean hasExternalKey(String externalKey) {
        boolean hasId;
        HashMap<String, String> hashMap = this.hmExternal;
        synchronized (hashMap) {
            hasId = this.hmExternal.containsKey(externalKey);
        }
        return hasId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getIDfromExternalKey(String externalKey) {
        String blobId = null;
        HashMap<String, String> hashMap = this.hmExternal;
        synchronized (hashMap) {
            if (this.hmExternal.containsKey(externalKey)) {
                blobId = this.hmExternal.get(externalKey);
            }
        }
        return blobId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getBlobFileName(String blobID) throws IOException {
        String sBlobFileName = null;
        HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
        synchronized (hashMap) {
            if (this.hasBlob(blobID)) {
                BlobCacheItem myBlob = this.hmBlobs.get(blobID);
                myBlob.dAccess = new Date();
                sBlobFileName = myBlob.sFilename;
            }
            return sBlobFileName;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String getBlobProperties(String blobID) throws IOException {
        Properties props = new Properties();
        String sBlobFileName = "";
        HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
        synchronized (hashMap) {
            if (this.hasBlob(blobID)) {
                BlobCacheItem myBlob = this.hmBlobs.get(blobID);
                myBlob.dAccess = new Date();
                sBlobFileName = myBlob.sFilename;
                props.setProperty("filename", sBlobFileName);
                props.setProperty("length", Long.toString(new File(myBlob.sFilename).length()));
                props.setProperty("md5", myBlob.fileMD5);
                props.setProperty("id", myBlob.sID);
                sBlobFileName = props.toString();
            }
        }
        return sBlobFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void freeBlobs(long sec) {
        Iterator<Object> it;
        Date myEqualDate = new Date(new Date().getTime() - sec * 1000L);
        ArrayList<String> vDelKeys = new ArrayList<String>(this.hmBlobs.size());
        String sKey2 = "";
        ArrayList<String> filenames = new ArrayList<String>();
        HashMap<String, Object> hashMap = this.hmBlobs;
        synchronized (hashMap) {
            for (String sKey2 : this.hmBlobs.keySet()) {
                BlobCacheItem myBlobItem = this.hmBlobs.get(sKey2);
                if (myBlobItem.getFilename() != null) {
                    File file = new File(myBlobItem.getFilename());
                    filenames.add(file.getName());
                    if (!file.exists()) {
                        vDelKeys.add(sKey2);
                    }
                }
                if (!myEqualDate.after(myBlobItem.dAccess)) continue;
                myBlobItem.freeResources();
                vDelKeys.add(sKey2);
            }
            it = null;
            for (int n = 0; n < vDelKeys.size(); ++n) {
                this.hmBlobs.remove((String)vDelKeys.get(n));
            }
            vDelKeys = null;
        }
        hashMap = this.hmExternal;
        synchronized (hashMap) {
            it = this.hmExternal.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = (Map.Entry)it.next();
                if (this.hasBlob((String)entry.getValue())) continue;
                it.remove();
            }
        }
        if (this.folders != null) {
            for (CacheFolder folder : this.folders) {
                folder.recount();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int getBlobCacheCount() {
        int size;
        HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
        synchronized (hashMap) {
            size = this.hmBlobs.size();
        }
        return size;
    }

    public final void freeResources() {
        this.freeBlobs(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String[] getBlobIDs() {
        String[] keys;
        HashMap<String, BlobCacheItem> hashMap = this.hmBlobs;
        synchronized (hashMap) {
            keys = new String[this.hmBlobs.size()];
            Iterator<String> it = this.hmBlobs.keySet().iterator();
            int n = 0;
            while (it.hasNext()) {
                keys[n] = it.next();
                ++n;
            }
            Object var3_3 = null;
        }
        return keys;
    }

    class CacheFolder {
        private int count;
        private File path;
        private int folderNumber;
        private int maxCount;

        public CacheFolder(File blobPath, int folderCount, int aMaxCount) throws IOException {
            this.folderNumber = folderCount;
            this.maxCount = aMaxCount;
            this.path = new File(blobPath, Integer.toHexString(this.folderNumber));
            this.path.mkdirs();
            File[] files = this.path.listFiles();
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                file.delete();
            }
            new FolderBlocker(this.path, true);
            this.initFolder();
        }

        private void initFolder() {
            this.recount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void recount() {
            if (this.path != null) {
                File file = this.path;
                synchronized (file) {
                    File[] files = this.path.listFiles(new FilenameFilter(){

                        @Override
                        public boolean accept(File dir, String name) {
                            return name.endsWith(".bin");
                        }
                    });
                    this.count = files.length;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final String getNewBlobName(String prefix, String suffix) throws IOException {
            String fileName = "";
            File file = this.path;
            synchronized (file) {
                if (this.count > this.maxCount) {
                    throw new IOException("to many files in this folder");
                }
                fileName = Files.getTempFileName(prefix, suffix, this.path.getAbsolutePath());
                ++this.count;
            }
            return fileName;
        }

        public final int getCount() {
            return this.count;
        }

        public final int getFolderNumber() {
            return this.folderNumber;
        }

        public final File getPath() {
            return this.path;
        }

        public boolean canCreate() {
            return this.count < this.maxCount;
        }
    }

    class BlobCacheItem
    implements Serializable {
        private static final long serialVersionUID = -871711242126446479L;
        private String sFilename;
        private String sID;
        private Date dAccess;
        private String fileMD5;
        private String externalKey;

        public BlobCacheItem(String filename, String externalKey) {
            this.sFilename = filename;
            this.fileMD5 = Files.computeMD5FromFile(new File(this.sFilename));
            this.sID = StringUtils.md5String(this.fileMD5 + new Date().getTime());
            this.dAccess = new Date();
            this.externalKey = externalKey;
        }

        public void freeResources() {
            new File(this.sFilename).delete();
        }

        protected void finalize() {
            this.freeResources();
        }

        public String getFilename() {
            return this.sFilename;
        }

        public void recalcBlobID() {
            this.sID = StringUtils.md5String(this.fileMD5 + new Date().getTime());
        }

        public String getExternalKey() {
            return this.externalKey;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append("filename:");
            buffer.append(this.sFilename);
            buffer.append(",ID:");
            buffer.append(this.sID);
            return buffer.toString();
        }
    }

    class KeyAlreadyExistsException
    extends Exception {
        private static final long serialVersionUID = 715224362894259926L;

        public KeyAlreadyExistsException(String string) {
            super(string);
        }
    }
}

