/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.security.AccessControlException;
import java.util.Hashtable;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUpdater {
    private File archiveFile;
    private ZipInputStream archive;
    private String baseDirPath;
    private String zipname;
    static final String METAINF_NAME = "META-INF/";
    static final String INDEX_NAME = "META-INF/INDEX.LIST";
    static final String MANIFEST_NAME = "META-INF/MANIFEST.MF";

    private String toZipName(String osFilename) {
        String zipName = osFilename;
        if (null != this.baseDirPath && this.baseDirPath.length() > 0 && this.baseDirPath.length() < osFilename.length() && osFilename.startsWith(this.baseDirPath)) {
            zipName = osFilename.substring(this.baseDirPath.length() + 1);
        }
        return zipName.replace(File.separatorChar, '/');
    }

    public ZipUpdater(File aArchiveFile, File baseDirFile) throws IOException {
        if (!aArchiveFile.exists()) {
            throw new FileNotFoundException(aArchiveFile.getAbsolutePath());
        }
        if (!aArchiveFile.canWrite()) {
            throw new AccessControlException("No write access", new FilePermission(aArchiveFile.getAbsolutePath(), "write"));
        }
        this.archiveFile = aArchiveFile;
        if (null == baseDirFile) {
            throw new NullPointerException("baseDirFile should not be null.");
        }
        if (!baseDirFile.exists()) {
            throw new FileNotFoundException(baseDirFile.getCanonicalPath());
        }
        this.baseDirPath = 0 == baseDirFile.getName().length() ? new File(System.getProperty("java.io.tmpdir")).getPath() : baseDirFile.getPath();
        this.zipname = this.toZipName(aArchiveFile.getPath());
    }

    public ZipUpdater(String archiveFilename, String baseDir) throws IOException {
        this(new File(archiveFilename), new File(baseDir));
    }

    public final File getFile() {
        return this.archiveFile;
    }

    public final void addFile(ZipOutputStream zipoutputstream, String aName, File file, byte[] buffer) throws IOException {
        String name = aName;
        boolean isDir = file.isDirectory();
        if (isDir) {
            String string = name = name.endsWith("/") ? name : name + "/";
        }
        if (name.startsWith("/")) {
            name = name.substring(1);
        } else if (name.startsWith("./")) {
            name = name.substring(2);
        }
        if (name.equals("") || name.equals(".") || name.equals(this.zipname)) {
            return;
        }
        long l = isDir ? 0L : file.length();
        ZipEntry zipentry = new ZipEntry(name);
        zipentry.setTime(file.lastModified());
        zipentry.setMethod(8);
        if (l == 0L) {
            zipentry.setMethod(0);
            zipentry.setSize(0L);
            zipentry.setCrc(0L);
        }
        zipoutputstream.putNextEntry(zipentry);
        if (!isDir) {
            int i;
            BufferedInputStream bufferedinputstream = new BufferedInputStream(new FileInputStream(file));
            while ((i = bufferedinputstream.read(buffer, 0, buffer.length)) > 0) {
                zipoutputstream.write(buffer, 0, i);
            }
            bufferedinputstream.close();
        }
        zipoutputstream.closeEntry();
    }

    public final void update(File toArchiveFile, File[] files, String[] asNames) throws IOException {
        ZipEntry zipentry;
        if (null == this.archive) {
            this.archive = new ZipInputStream(new FileInputStream(this.archiveFile));
        }
        if (null == files) {
            return;
        }
        Hashtable<String, File> hashtable = new Hashtable<String, File>();
        for (int index = 0; index < files.length; ++index) {
            String name = this.toZipName(files[index].getPath());
            if (null != asNames && null != asNames[index]) {
                name = asNames[index];
            }
            hashtable.put(name, files[index]);
        }
        hashtable.remove(INDEX_NAME);
        hashtable.remove(MANIFEST_NAME);
        JarOutputStream jaroutputstream = new JarOutputStream(new FileOutputStream(toArchiveFile));
        jaroutputstream.setLevel(9);
        byte[] buffer = new byte[8192];
        while (null != (zipentry = this.archive.getNextEntry())) {
            String name = zipentry.getName();
            if (name.equalsIgnoreCase(INDEX_NAME)) continue;
            if (!hashtable.containsKey(name)) {
                int len;
                ZipEntry newEntry = new ZipEntry(name);
                newEntry.setMethod(zipentry.getMethod());
                newEntry.setTime(zipentry.getTime());
                newEntry.setComment(zipentry.getComment());
                newEntry.setExtra(zipentry.getExtra());
                if (0 == zipentry.getMethod()) {
                    newEntry.setSize(zipentry.getSize());
                    newEntry.setCrc(zipentry.getCrc());
                }
                jaroutputstream.putNextEntry(newEntry);
                while ((len = this.archive.read(buffer, 0, buffer.length)) != -1) {
                    jaroutputstream.write(buffer, 0, len);
                }
                continue;
            }
            this.addFile(jaroutputstream, name, (File)hashtable.get(name), buffer);
            hashtable.remove(name);
        }
        if (!hashtable.isEmpty()) {
            for (Map.Entry entry : hashtable.entrySet()) {
                this.addFile(jaroutputstream, (String)entry.getKey(), (File)entry.getValue(), buffer);
            }
        }
        jaroutputstream.close();
    }

    public final void close() throws IOException {
        if (null != this.archive) {
            this.archive.close();
            this.archive = null;
        }
    }

    public final String toString() {
        return this.archiveFile.toString();
    }
}

