/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessControlException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class ZipExtracter {
    private File archiveFile;
    private ZipFile archive;
    private String baseDirPath;
    private static int recursioncnt = 0;

    public final File getFile() {
        return this.archiveFile;
    }

    public final String getName() {
        return null == this.archive ? null : this.archive.getName();
    }

    private String toZipName(String osFilename) {
        String zipName = osFilename;
        if (null != this.baseDirPath && this.baseDirPath.length() > 0 && this.baseDirPath.length() < osFilename.length() && osFilename.startsWith(this.baseDirPath)) {
            zipName = osFilename.substring(this.baseDirPath.length() + 1);
        }
        return zipName.replace(File.separatorChar, '/');
    }

    public ZipExtracter(File aArchiveFile, File aBaseDirFile) throws IOException {
        if (!aArchiveFile.exists()) {
            throw new FileNotFoundException(aArchiveFile.getAbsolutePath());
        }
        if (!aArchiveFile.canRead()) {
            throw new AccessControlException("No read access", new FilePermission(aArchiveFile.getAbsolutePath(), "read"));
        }
        this.archiveFile = aArchiveFile;
        this.baseDirPath = null == aBaseDirFile || 0 == aBaseDirFile.getName().length() ? new File(System.getProperty("java.io.tmpdir")).getPath() : aBaseDirFile.getPath();
        this.toZipName(aArchiveFile.getPath());
    }

    public ZipExtracter(String archiveFilename, String baseDir) throws IOException {
        this(new File(archiveFilename), new File(baseDir));
    }

    public final File extract(String fromFilename, String toLocalFilename) throws IOException {
        File localFilename;
        File parent;
        if (null == this.archive) {
            this.archive = new ZipFile(this.archiveFile);
        }
        if (null != (parent = (localFilename = null == toLocalFilename ? new File(this.baseDirPath, fromFilename) : new File(toLocalFilename)).getParentFile())) {
            parent.mkdirs();
        }
        Enumeration<? extends ZipEntry> archiveEntries = this.archive.entries();
        byte[] buffer = new byte[8192];
        while (archiveEntries.hasMoreElements()) {
            int len;
            ZipEntry entry = archiveEntries.nextElement();
            if (entry.isDirectory() || !entry.getName().equalsIgnoreCase(fromFilename) || entry.getSize() <= 0L) continue;
            InputStream input = this.archive.getInputStream(entry);
            FileOutputStream output = new FileOutputStream(localFilename);
            while ((len = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, len);
            }
            output.close();
            return localFilename;
        }
        throw new FileNotFoundException("The file '" + fromFilename + "' is not contained in '" + this.archive.getName() + " or is a directory.");
    }

    public final void close() throws IOException {
        if (null != this.archive) {
            this.archive.close();
            this.archive = null;
        }
    }

    public final String toString() {
        return this.archiveFile.toString();
    }

    public final void extractAll() throws IOException {
        this.extractAll(false, 0);
    }

    public final void extractAll(boolean recursive, int recursionDepth) throws IOException {
        if (null == this.archive) {
            this.archive = new ZipFile(this.archiveFile);
        }
        Enumeration<? extends ZipEntry> archiveEntries = this.archive.entries();
        byte[] buffer = new byte[8192];
        while (archiveEntries.hasMoreElements()) {
            int len;
            ZipEntry entry = archiveEntries.nextElement();
            if (entry.isDirectory() || entry.getSize() <= 0L) continue;
            File outfile = new File(this.baseDirPath, entry.getName());
            outfile.getParentFile().mkdirs();
            InputStream input = this.archive.getInputStream(entry);
            FileOutputStream output = new FileOutputStream(outfile);
            while ((len = input.read(buffer, 0, buffer.length)) != -1) {
                output.write(buffer, 0, len);
            }
            output.close();
            input.close();
            if (!recursive || !entry.getName().matches("(.*[(e)|(w)|(j)]ar)|(.*zip)") || recursioncnt >= recursionDepth) continue;
            ++recursioncnt;
            File subdir = new File(this.baseDirPath, entry.getName().substring(0, entry.getName().length() - 4));
            File subjar = new File(this.baseDirPath, entry.getName());
            ZipExtracter xarex = new ZipExtracter(subjar, subdir);
            xarex.extractAll(true, recursionDepth);
            xarex.close();
            --recursioncnt;
        }
    }
}

