/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.XMLChar;
import de.mcs.utils.codecs.Base64;
import java.io.UnsupportedEncodingException;

public final class XMLConverter {
    private static final String BOUNDARY_BASE64 = "{b64}";

    private XMLConverter() {
    }

    public static void main(String[] args) {
        System.out.println("1:" + XMLConverter.convertDataToXML("test von Zeichen."));
        System.out.println("2:" + XMLConverter.convertDataToXML("test & < > ' \" Zeichen."));
        System.out.println("3:" + XMLConverter.convertDataToXML("&test von Zeichen.>"));
        System.out.println("4:" + XMLConverter.convertDataToXML("&"));
    }

    public static String convertDataToXML(String data) {
        char[] chars = data.toCharArray();
        StringBuffer result = new StringBuffer();
        if (data != null) {
            int length = data.length();
            int fpos = 0;
            block7: for (int i = 0; i < length; ++i) {
                char ch = chars[i];
                switch (ch) {
                    case '&': {
                        result.append(data.substring(fpos, i));
                        result.append("&amp;");
                        fpos = i + 1;
                        continue block7;
                    }
                    case '<': {
                        result.append(data.substring(fpos, i));
                        result.append("&lt;");
                        fpos = i + 1;
                        continue block7;
                    }
                    case '>': {
                        result.append(data.substring(fpos, i));
                        result.append("&gt;");
                        fpos = i + 1;
                        continue block7;
                    }
                    case '\"': {
                        result.append(data.substring(fpos, i));
                        result.append("&quot;");
                        fpos = i + 1;
                        continue block7;
                    }
                    case '\'': {
                        result.append(data.substring(fpos, i));
                        result.append("&apos;");
                        fpos = i + 1;
                        continue block7;
                    }
                }
            }
            if (fpos < length) {
                result.append(data.substring(fpos, length));
            }
        }
        return result.toString();
    }

    public static String convertDataToCDATA(String data) {
        String mydata = "<![CDATA[" + data + "]]>";
        return mydata;
    }

    public static boolean mustEncode(String data) {
        if (data != null) {
            return XMLConverter.hasIllegalXMLChar(data) | data.indexOf("]]>") >= 0;
        }
        return false;
    }

    public static boolean hasIllegalXMLChar(String data) {
        if (data != null) {
            char[] chars = data.toCharArray();
            boolean result = false;
            for (int n = 0; n < chars.length && !result; result |= XMLChar.isInvalid(chars[n]), ++n) {
            }
            return result;
        }
        return false;
    }

    public static String encodeStringData(String data) {
        String value = data;
        if (XMLConverter.mustEncode(value)) {
            try {
                value = BOUNDARY_BASE64 + Base64.encodeBytes(value.getBytes("UTF-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        return value;
    }

    public static String decodeStringData(String data) {
        String value = data;
        if (value.startsWith(BOUNDARY_BASE64)) {
            try {
                value = new String(Base64.decode(value.substring(BOUNDARY_BASE64.length())), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new Error(e);
            }
        }
        return value;
    }
}

