/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

public class Version {
    private int major = -1;
    private int minor = -1;
    private int release = -1;
    private int build = -1;

    public Version() {
    }

    public Version(String version) {
        this();
        this.parseString(version);
    }

    public final void parseString(String version) {
        String[] versionvalues = version.split("\\.");
        block6: for (int i = 0; i < versionvalues.length; ++i) {
            String string = versionvalues[i];
            switch (i) {
                case 0: {
                    this.major = Integer.parseInt(string);
                    continue block6;
                }
                case 1: {
                    this.minor = Integer.parseInt(string);
                    continue block6;
                }
                case 2: {
                    this.release = Integer.parseInt(string);
                    continue block6;
                }
                case 3: {
                    this.build = Integer.parseInt(string);
                    continue block6;
                }
            }
        }
    }

    public Version(Version version) {
        this();
        this.major = version.major;
        this.minor = version.minor;
        this.release = version.release;
        this.build = version.build;
    }

    public final void incrementMajor() {
        ++this.major;
    }

    public final void incrementMinor() {
        ++this.minor;
    }

    public final void incrementRelease() {
        ++this.release;
    }

    public final void incrementBuild() {
        ++this.build;
    }

    public final void decrementMajor() {
        --this.major;
    }

    public final void decrementMinor() {
        --this.minor;
    }

    public final void decrementRelease() {
        --this.release;
    }

    public final void decrementBuild() {
        --this.build;
    }

    public final boolean greaterThan(Version dest) {
        if (this.major == dest.major) {
            if (this.minor == dest.minor) {
                if (this.release == dest.release) {
                    return this.build > dest.build;
                }
                return this.release > dest.release;
            }
            return this.minor > dest.minor;
        }
        return this.major > dest.major;
    }

    public final boolean lesserThan(Version dest) {
        return !this.equals(dest) && !this.greaterThan(dest);
    }

    public final boolean equals(Object arg0) {
        if (arg0 instanceof Version) {
            Version dest = (Version)arg0;
            if (this.major == dest.major) {
                if (this.minor == dest.minor) {
                    if (this.release == dest.release) {
                        return this.build == dest.build;
                    }
                    return false;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer(20);
        stringBuffer.append(this.major);
        if (this.minor >= 0) {
            stringBuffer.append(".").append(this.minor);
            if (this.release >= 0) {
                stringBuffer.append(".").append(this.release);
                if (this.build >= 0) {
                    stringBuffer.append(".").append(this.build);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] args) {
        Version version = new Version("2.1.2.97");
        Version version1 = new Version("2.1.2.96");
        System.out.print("Version " + version.toString() + " > " + version1.toString() + ": ");
        System.out.println(version.greaterThan(version1));
        System.out.print("Version " + version.toString() + " < " + version1.toString() + ": ");
        System.out.println(version.lesserThan(version1));
        System.out.print("Version " + version.toString() + " = " + version1.toString() + ": ");
        System.out.println(version.equals(version1));
        System.out.print("Version " + version.toString() + " = \"String\": ");
        System.out.println(version.equals("String"));
        version1 = new Version(version.toString());
        System.out.print("Version " + version.toString() + " > " + version1.toString() + ": ");
        System.out.println(version.greaterThan(version1));
        System.out.print("Version " + version.toString() + " < " + version1.toString() + ": ");
        System.out.println(version.lesserThan(version1));
        System.out.print("Version " + version.toString() + " = " + version1.toString() + ": ");
        System.out.println(version.equals(version1));
        version = new Version("2.1.97");
        version1 = new Version("2.1.96");
        System.out.print("Version " + version.toString() + " > " + version1.toString() + ": ");
        System.out.println(version.greaterThan(version1));
    }

    public final int getBuild() {
        return this.build;
    }

    public final int getMajor() {
        return this.major;
    }

    public final int getMinor() {
        return this.minor;
    }

    public final int getRelease() {
        return this.release;
    }

    public final int hashCode() {
        int hash = this.major ^ this.minor ^ this.release ^ this.build;
        return hash;
    }

    public final void setBuild(int aBuild) {
        this.build = aBuild;
    }

    public final void setMajor(int aMajor) {
        this.major = aMajor;
    }

    public final void setMinor(int aMinor) {
        this.minor = aMinor;
    }

    public final void setRelease(int aRelease) {
        this.release = aRelease;
    }
}

