/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.WorkingThread;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.LinkedBlockingQueue;

public class ThreadPool
extends Thread {
    private ArrayList<WorkingThread> pool;
    private Queue<Runnable> queue;
    private int maxCount;

    public ThreadPool(int maxcount) {
        this.maxCount = maxcount;
        this.pool = new ArrayList(this.maxCount);
        this.queue = new LinkedBlockingQueue<Runnable>(100);
    }

    public final boolean addWorkingPart(Runnable work) {
        return this.queue.offer(work);
    }

    public final boolean removeWorkingPart(Runnable work) {
        return this.queue.remove(work);
    }

    @Override
    public final void run() {
        while (!this.isInterrupted()) {
            if (!this.queue.isEmpty()) {
                Runnable run = this.queue.poll();
                try {
                    WorkingThread thread = this.getNextFreeThread();
                    thread.setRunnable(run);
                    thread.start();
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            try {
                ThreadPool.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    private WorkingThread getNextFreeThread() throws InterruptedException {
        WorkingThread thread;
        while (this.maxCount < this.pool.size()) {
            thread = this.getFreeThread();
            this.pool.remove(thread);
            thread = null;
        }
        while (this.maxCount > this.pool.size()) {
            thread = new WorkingThread();
            this.pool.add(thread);
        }
        return this.getFreeThread();
    }

    private WorkingThread getFreeThread() throws InterruptedException {
        while (true) {
            for (WorkingThread thread : this.pool) {
                if (!thread.isFree()) continue;
                thread.setBusy();
                return thread;
            }
            ThreadPool.sleep(50L);
        }
    }
}

