/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.StringFormat;
import de.mcs.utils.codecs.Base64;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;

public final class StringUtils {
    private static final String SPACE = " ";
    static byte[] raw = new byte[]{84, 104, 105, 115, 73, 115, 65, 83, 101, 99, 114, 101, 116, 75, 101, 121};

    private StringUtils() {
    }

    public static StringBuffer replaceAll(StringBuffer buffer, String find, String replacement) {
        int bufidx = buffer.length() - 1;
        int offset = find.length();
        while (bufidx > -1) {
            int findidx = offset - 1;
            while (findidx > -1) {
                if (bufidx == -1) {
                    return buffer;
                }
                if (buffer.charAt(bufidx) == find.charAt(findidx)) {
                    --findidx;
                    --bufidx;
                    continue;
                }
                findidx = offset - 1;
                if (--bufidx != -1) continue;
                return buffer;
            }
            buffer.replace(bufidx + 1, bufidx + 1 + offset, replacement);
        }
        return buffer;
    }

    public static String listToCSVString(List<String> list) {
        return StringUtils.listToCSVString(list, false);
    }

    public static String listToCSVString(List<String> list, boolean forceDelimiter) {
        String[] array = new String[list.size()];
        for (int i = 0; i < array.length; ++i) {
            array[i] = list.get(i).toString();
        }
        return StringUtils.arrayToCSVString(array, ',', '\"', forceDelimiter);
    }

    public static String arrayToCSVString(String[] array) {
        return StringUtils.arrayToCSVString(array, ',', '\"');
    }

    public static String arrayToCSVString(String[] array, char localseparators, char localdelimiter) {
        return StringUtils.arrayToCSVString(array, localseparators, localdelimiter, false);
    }

    public static String arrayToCSVString(String[] array, char localseparators, char localdelimiter, boolean forceDelimiter) {
        String delimiter = Character.toString(localdelimiter);
        String separators = Character.toString(localseparators);
        StringBuffer sb = new StringBuffer("");
        String empty = "";
        if (array == null || array.length == 0) {
            return empty;
        }
        if (delimiter == null) {
            delimiter = "\"";
        }
        if (separators == null) {
            separators = ",";
        }
        for (int ix = 0; ix < array.length; ++ix) {
            if (array[ix] == null) continue;
            StringBuffer value = new StringBuffer(array[ix]);
            if (value.indexOf(delimiter) >= 0) {
                value = StringUtils.replaceAll(value, delimiter, delimiter + delimiter);
            }
            if (forceDelimiter || array[ix].indexOf(separators) >= 0 || array[ix].indexOf(delimiter) >= 0 || array[ix].startsWith(SPACE)) {
                sb.append(delimiter);
                sb.append(value);
                sb.append(delimiter);
                sb.append(separators);
                continue;
            }
            sb.append(value);
            sb.append(separators);
        }
        String str = sb.toString();
        if (!str.equals("")) {
            str = str.substring(0, str.length() - separators.length());
        }
        return str;
    }

    public static String[] csvStringToArray(String string) {
        return StringUtils.csvStringToArray(string, ',', '\"');
    }

    public static String[] csvStringToArray(String str, char localseparators, char localdelimiter) {
        class CSV {
            ArrayList<String> list = new ArrayList();
            private char fieldSep;
            private char fieldDelim;

            public CSV(char sep, char delim) {
                this.fieldSep = sep;
                this.fieldDelim = delim;
            }

            public final Iterator<String> parse(String line) {
                StringBuffer sb = new StringBuffer();
                this.list.clear();
                int i = 0;
                if (line.length() == 0) {
                    return this.list.iterator();
                }
                do {
                    sb.setLength(0);
                    if (i < line.length() && line.charAt(i) == this.fieldDelim) {
                        ++i;
                        i = this.advQuoted(line, sb, i);
                    } else {
                        i = this.advPlain(line, sb, i);
                    }
                    this.list.add(sb.toString());
                } while (++i < line.length());
                return this.list.iterator();
            }

            private int advQuoted(String s, StringBuffer sb, int i) {
                int j;
                int len = s.length();
                for (j = i; j < len; ++j) {
                    if (s.charAt(j) == this.fieldDelim && j + 1 < len) {
                        if (s.charAt(j + 1) == this.fieldDelim) {
                            ++j;
                        } else if (s.charAt(j + 1) == this.fieldSep) {
                            ++j;
                            break;
                        }
                    } else if (s.charAt(j) == this.fieldDelim && j + 1 == len) break;
                    sb.append(s.charAt(j));
                }
                return j;
            }

            private int advPlain(String s, StringBuffer sb, int i) {
                int j = s.indexOf(this.fieldSep, i);
                if (j == -1) {
                    sb.append(s.substring(i));
                    return s.length();
                }
                sb.append(s.substring(i, j));
                return j;
            }
        }
        CSV csv = new CSV(localseparators, localdelimiter);
        csv.parse(str);
        return csv.list.toArray(new String[0]);
    }

    public static String removeChars(String data, String removeChars) {
        String temp = null;
        StringBuffer out = new StringBuffer();
        temp = data;
        StringTokenizer st = new StringTokenizer(temp, removeChars);
        while (st.hasMoreTokens()) {
            String element = (String)st.nextElement();
            out.append(element);
        }
        return out.toString();
    }

    public static String stripExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (index > -1) {
            return filename.substring(0, index);
        }
        return filename;
    }

    public static String replaceVars(String origString, Map<String, String> vars) {
        StringBuffer finalString = new StringBuffer();
        int index = 0;
        int i = 0;
        String key = null;
        String value = null;
        while ((index = origString.indexOf("${", i)) > -1) {
            key = origString.substring(index + 2, origString.indexOf("}", index + 3));
            value = vars.get(key);
            finalString.append(origString.substring(i, index));
            if (value != null) {
                finalString.append(value);
            } else {
                finalString.append("${" + key + "}");
            }
            i = index + 3 + key.length();
        }
        finalString.append(origString.substring(i));
        return finalString.toString();
    }

    public static int isInArray(String[] fieldProps, String strSearchValue) {
        for (int i = 0; i < fieldProps.length; ++i) {
            if (!fieldProps[i].equals(strSearchValue)) continue;
            return i;
        }
        return -1;
    }

    public static String byteArrayToMimeString(byte[] array) throws IOException {
        return Base64.encodeBytes(array);
    }

    public static byte[] mimeStringTobyteArray(String string) throws Exception {
        return Base64.decode(string);
    }

    public static String md5String(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            byte[] digest = md.digest();
            return StringFormat.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] md5StringBytes(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes());
            byte[] digest = md.digest();
            return digest;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String md5UTF8String(String s) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(s.getBytes("UTF-8"));
            byte[] digest = md.digest();
            return StringFormat.toHexString(digest);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static byte[] xorArrays(byte[] arg0, byte[] arg1) {
        byte[] xor = new byte[arg0.length];
        int keylength = arg1.length;
        for (int i = 0; i < xor.length; ++i) {
            xor[i] = (byte)(arg0[i] ^ arg1[i % keylength]);
        }
        return xor;
    }

    public static String formatFieldData(String aValue, int size) {
        StringBuffer value = new StringBuffer(aValue);
        while (value.length() < size) {
            value.append(SPACE);
        }
        if (value.length() > size) {
            value = new StringBuffer(value.substring(0, size));
        }
        return value.toString();
    }

    public static List<String> toList(String[] strings) {
        ArrayList<String> list = new ArrayList<String>(strings.length);
        for (int i = 0; i < strings.length; ++i) {
            list.add(strings[i]);
        }
        return list;
    }

    public static List<String> csvStringToList(String string) {
        String[] strings = StringUtils.csvStringToArray(string, ',', '\"');
        return StringUtils.toList(strings);
    }

    public static List<String> csvStringToList(String string, char localseparator, char localdelimiter) {
        String[] strings = StringUtils.csvStringToArray(string, localseparator, localdelimiter);
        return StringUtils.toList(strings);
    }

    public static Map<String, String> csvStringToPropMap(String csvString, char csvSeparators, char csvDelimiter, char propSeparator) {
        String[] propStrings;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String propString : propStrings = StringUtils.csvStringToArray(csvString, csvSeparators, csvDelimiter)) {
            int pos = propString.indexOf(propSeparator);
            if (pos < 0) continue;
            String key = propString.substring(0, pos);
            String value = propString.substring(pos + 1);
            map.put(key, value);
        }
        return map;
    }

    public static String propMapToCsvString(Map<String, String> map, char csvSeparators, char csvDelimiter, char propSeparator) {
        StringBuilder b = new StringBuilder();
        Iterator<Map.Entry<String, String>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            b.append(csvDelimiter);
            b.append(entry.getKey());
            b.append(propSeparator);
            b.append(entry.getValue());
            b.append(csvDelimiter);
            if (!iterator.hasNext()) continue;
            b.append(csvSeparators);
        }
        return b.toString();
    }

    public static String encrypt(String value, byte[] key) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(1, skeySpec);
            byte[] encrypted = cipher.doFinal(value.getBytes());
            return Base64.encodeBytes(encrypted);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String decrypt(String encrypted, byte[] key) {
        try {
            SecretKeySpec skeySpec = new SecretKeySpec(key, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(2, skeySpec);
            byte[] original = cipher.doFinal(Base64.decode(encrypted));
            return new String(original);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

