/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class StringFormat {
    private static MessageDigest standardMd;
    private static final String SPECIALSAVECHARS = "\\";
    private static final char[] HEX_CHARS;
    private static final String HEX_STRING = "0123456789ABCDEF";
    private static final char[] HEXDIGIT;

    private StringFormat() {
    }

    public static void byte2hex(byte b, StringBuffer buf) {
        int high = (b & 0xF0) >> 4;
        int low = b & 0xF;
        buf.append(HEX_CHARS[high]);
        buf.append(HEX_CHARS[low]);
    }

    public static String toHexString(byte[] block) {
        StringBuffer buf = new StringBuffer();
        int len = block.length;
        for (int i = 0; i < len; ++i) {
            StringFormat.byte2hex(block[i], buf);
        }
        return buf.toString();
    }

    public static byte[] fromHexString(String str) {
        int low;
        String hexStr = str.toUpperCase();
        int len = hexStr.length();
        int l = len / 2;
        byte[] bytes = new byte[l + len % 2];
        int i = 0;
        int n = 0;
        while (i + 1 < len) {
            low = HEX_STRING.indexOf(hexStr.charAt(i + 1));
            int high = HEX_STRING.indexOf(hexStr.charAt(i));
            if (-1 == low || -1 == high) {
                throw new NumberFormatException(hexStr);
            }
            bytes[n] = (byte)(high << 4 | low);
            i += 2;
            ++n;
        }
        if (len % 2 > 0) {
            low = HEX_STRING.indexOf(hexStr.charAt(i));
            if (-1 == low) {
                throw new NumberFormatException(hexStr);
            }
            bytes[n] = (byte)low;
        }
        return bytes;
    }

    public static int strToInt(String strNum) {
        return Integer.parseInt(strNum);
    }

    public static String getPathFromString(String string, int directoryDepth) {
        int maxdirectoryDepth = string.length() / 2;
        StringBuffer buf = new StringBuffer();
        if (directoryDepth <= maxdirectoryDepth && directoryDepth >= 0) {
            String filedelim = System.getProperty("file.separator");
            for (int i = 0; i < directoryDepth * 2; ++i) {
                if (i > 0 && i % 2 == 0) {
                    buf.append(filedelim);
                }
                buf.append(string.charAt(i));
            }
            buf.append(filedelim);
        }
        return buf.toString();
    }

    public static String formatLong(long l, int length, char fill) {
        String x = String.valueOf(l);
        if (x.length() < length) {
            StringBuffer z = new StringBuffer();
            int s = length - x.length();
            for (int i = 0; i < s; ++i) {
                z.append(fill);
            }
            z.append(x);
            return z.toString();
        }
        return x;
    }

    public static String formatStringLeading(String x, int length, char fill) {
        if (x.length() < length) {
            StringBuffer z = new StringBuffer();
            int s = length - x.length();
            for (int i = 0; i < s; ++i) {
                z.append(fill);
            }
            z.append(x);
            return z.toString();
        }
        if (x.length() == length) {
            return x;
        }
        return x.substring(0, length + 1);
    }

    public static String formatString(String x, int length, char fill) {
        if (x.length() < length) {
            StringBuffer z = new StringBuffer(x);
            int s = length - x.length();
            for (int i = 0; i < s; ++i) {
                z.append(fill);
            }
            return z.toString();
        }
        if (x.length() == length) {
            return x;
        }
        return x.substring(0, length + 1);
    }

    public static String md5String(String s) {
        try {
            MessageDigest md = (MessageDigest)standardMd.clone();
            md.update(s.getBytes());
            byte[] digest = md.digest();
            return StringFormat.toHexString(digest);
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String wellForm(String g) {
        StringBuffer newString = new StringBuffer();
        int s = g.length();
        block7: for (int i = 0; i < s; ++i) {
            char t = g.charAt(i);
            switch (t) {
                case '&': {
                    newString.append("&amp;");
                    continue block7;
                }
                case '>': {
                    newString.append("&gt;");
                    continue block7;
                }
                case '<': {
                    newString.append("&lt;");
                    continue block7;
                }
                case '\"': {
                    newString.append("&quot;");
                    continue block7;
                }
                case '\'': {
                    newString.append("&apos;");
                    continue block7;
                }
                default: {
                    newString.append(t);
                }
            }
        }
        return newString.toString();
    }

    public static String getList(Collection<Object> col, char sep) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        for (Object element : col) {
            if (!first) {
                buf.append(sep);
            }
            first = false;
            if (element.toString().indexOf(sep) != -1) {
                buf.append('\"');
                buf.append(element.toString());
                buf.append('\"');
                continue;
            }
            buf.append(element.toString());
        }
        return buf.toString();
    }

    public static List<String> parseList(String col, char sep) {
        ArrayList<String> q = new ArrayList<String>();
        StringBuffer element = new StringBuffer();
        boolean ignore = false;
        for (int i = 0; i < col.length(); ++i) {
            char v = col.charAt(i);
            if (v == sep) {
                if (!ignore) {
                    q.add(element.toString());
                    element = new StringBuffer();
                    continue;
                }
                element.append(v);
                continue;
            }
            if (v == '\"') {
                if (element.length() == 0) {
                    ignore = true;
                    continue;
                }
                if (ignore) {
                    ignore = false;
                    continue;
                }
                element.append(v);
                continue;
            }
            element.append(v);
        }
        if (element.length() != 0) {
            q.add(element.toString());
        }
        return q;
    }

    public static String containsChars(String source, String chars) {
        StringBuffer errorChars = new StringBuffer();
        int length = source.length();
        for (int i = 0; i < length; ++i) {
            char c = source.charAt(i);
            if (chars.indexOf(c) == -1 || errorChars.toString().indexOf(c) != -1) continue;
            errorChars.append(c);
        }
        if (errorChars.length() > 0) {
            return errorChars.toString();
        }
        return null;
    }

    public static int countsChars(String searchString, char character) {
        int count = 0;
        int s = searchString.length();
        for (int i = 0; i < s; ++i) {
            if (searchString.charAt(i) != character) continue;
            ++count;
        }
        return count;
    }

    public static String[] fromCollection(Collection<Object> r) {
        String[] values = new String[r.size()];
        int i = 0;
        Iterator<Object> iter = r.iterator();
        while (iter.hasNext()) {
            String element = iter.next().toString();
            values[i++] = element;
        }
        return values;
    }

    public static String filterWhiteSpace(String s) {
        StringBuffer result = new StringBuffer();
        String sResult = "";
        for (int i = 0; i < s.length(); ++i) {
            char x = s.charAt(i);
            if (x > '\u001f') {
                result.append(x);
                continue;
            }
            result.append(' ');
        }
        sResult = result.toString();
        while (sResult.endsWith(" ")) {
            sResult = sResult.substring(0, sResult.length() - 1);
        }
        return sResult;
    }

    public static String replaceString(String newString, String source, String searchStr) {
        int position;
        String sResult = source;
        while ((position = source.indexOf(searchStr)) != -1) {
            String start = position > 0 ? source.substring(0, position) : "";
            String end = position + searchStr.length() - 1 < source.length() - 1 ? source.substring(position + searchStr.length(), source.length()) : "";
            sResult = start + newString + end;
        }
        return sResult;
    }

    public static String getProperty(String property, String defaultValue, Collection<String> col) {
        String value = defaultValue;
        for (String element : col) {
            String prop;
            int i = element.indexOf(61);
            if (i == -1 || !(prop = element.substring(0, i).trim()).equalsIgnoreCase(property)) continue;
            value = element.substring(i + 1).trim();
            if (!value.startsWith("\"") || !value.endsWith("\"")) break;
            value = value.substring(1, value.length() - 1);
            break;
        }
        return value;
    }

    public static Map<String, String> getProperties(Collection<String> col) {
        HashMap<String, String> props = new HashMap<String, String>();
        for (String element : col) {
            int i = element.indexOf(61);
            if (i == -1) continue;
            String prop = element.substring(0, i).trim();
            String value = element.substring(i + 1);
            props.put(prop, value);
        }
        return props;
    }

    public static String getPropertyString(Map<String, String> props) {
        StringBuffer result = new StringBuffer();
        for (String element : props.keySet()) {
            String value = element + "=" + props.get(element);
            if (value.indexOf(",") != -1) {
                value = '\"' + value + '\"';
            }
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(value);
        }
        return result.toString();
    }

    public static String setProperty(String property, String value, String propertyString) {
        Map<String, String> m = StringFormat.getProperties(StringFormat.parseList(propertyString, ','));
        m.put(property, value);
        return StringFormat.getPropertyString(m);
    }

    public static Collection<String> getMultiLineString(String input) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuffer actual = new StringBuffer();
        int length = input.length();
        for (int i = 0; i < length; ++i) {
            char ch = input.charAt(i);
            if (ch == '\n' || ch == '\r') {
                if (actual.length() != 0) {
                    lines.add(actual.toString());
                }
                actual = new StringBuffer();
                continue;
            }
            actual.append(ch);
        }
        if (actual.length() != 0) {
            lines.add(actual.toString());
        }
        return lines;
    }

    public static String filterString(String input, char left, char right) {
        int iRight;
        String sReturn = input;
        int iLeft = input.indexOf(left);
        if (iLeft > -1) {
            sReturn = input.substring(iLeft + 1);
        }
        if ((iRight = sReturn.indexOf(right)) > -1) {
            sReturn = sReturn.substring(0, iRight);
        }
        return sReturn;
    }

    public static String filterString(String input, char filterchar) {
        String sReturn = input;
        while (sReturn.startsWith("" + filterchar)) {
            sReturn = sReturn.substring(1);
        }
        while (sReturn.endsWith("" + filterchar)) {
            sReturn = sReturn.substring(0, sReturn.length() - 1);
        }
        return sReturn;
    }

    public static String rtrim(String s) {
        int firstx = 0;
        int i = s.length() - 1;
        while (i >= 0 && s.charAt(i) <= ' ') {
            firstx = i--;
        }
        if (firstx == 0) {
            return "";
        }
        return s.substring(0, firstx);
    }

    public static String convertEscapes(String s) {
        StringBuffer r = new StringBuffer();
        StringBuffer hexBuffer = null;
        boolean code = false;
        int hexCount = 0;
        int length = s.length();
        for (int i = 0; i < length; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                code = true;
                continue;
            }
            if (code) {
                switch (c) {
                    case '0': {
                        hexBuffer = new StringBuffer();
                        hexCount = -1;
                        code = false;
                        break;
                    }
                    case 'r': {
                        r.append('\r');
                        code = false;
                        break;
                    }
                    case 'f': {
                        r.append('\f');
                        code = false;
                        break;
                    }
                    case 'n': {
                        r.append('\n');
                        code = false;
                        break;
                    }
                    case 't': {
                        r.append('\t');
                        code = false;
                        break;
                    }
                    case '\\': {
                        r.append('\\');
                        code = false;
                        break;
                    }
                }
                continue;
            }
            if (hexCount != 0) {
                if (hexCount == -1) {
                    if (c == 'x') {
                        hexCount = 2;
                        continue;
                    }
                    if (c == 'u') {
                        hexCount = 4;
                        continue;
                    }
                    hexCount = 0;
                    continue;
                }
                hexBuffer.append(c);
                if (--hexCount != 0) continue;
                r.append((char)Integer.parseInt(hexBuffer.toString(), 16));
                continue;
            }
            r.append(c);
        }
        return r.toString();
    }

    public static String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        StringBuffer outBuffer = new StringBuffer(len * 2);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\\': {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                default: {
                    if (SPECIALSAVECHARS.indexOf(aChar) != -1) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return HEXDIGIT[nibble & 0xF];
    }

    public static String getStackTrace(Throwable cause) {
        StackTraceElement[] elements = cause.getStackTrace();
        StringBuffer buffer = new StringBuffer(1024);
        buffer.append(cause);
        for (int i = 0; i < elements.length; ++i) {
            StackTraceElement element = elements[i];
            buffer.append("\r\n\tat ");
            buffer.append(element.toString());
        }
        return buffer.toString();
    }

    public static String left(String string, int pos) {
        return string.substring(0, pos);
    }

    public static String right(String string, int pos) {
        return string.substring(pos);
    }

    public static String[] splitFirst(String string, String search) {
        String[] result = new String[2];
        int pos = string.indexOf(search);
        if (pos == -1) {
            result[0] = string;
        } else {
            result[0] = StringFormat.left(string, pos);
            if (pos < string.length()) {
                result[1] = StringFormat.right(string, pos + search.length());
            }
        }
        return result;
    }

    public static boolean isUppercase(String string) {
        for (int index = 0; index < string.length(); ++index) {
            if (Character.isUpperCase(string.codePointAt(index))) continue;
            return false;
        }
        return true;
    }

    static {
        try {
            standardMd = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    }
}

