/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Arrays;

public final class StreamHelper {
    private static final int BUFFER_SIZE = 32768;

    private StreamHelper() {
    }

    public static long copyStream(InputStream in, OutputStream out) throws IOException {
        long written = 0L;
        byte[] buffer = new byte[32768];
        int k = 0;
        do {
            if ((k = in.read(buffer)) <= 0) continue;
            out.write(buffer, 0, k);
            written += (long)k;
        } while (k >= 0);
        return written;
    }

    public static long copyStream(InputStream in, OutputStream out, int bufSize) throws IOException {
        long written = 0L;
        byte[] buffer = new byte[bufSize];
        int k = 0;
        do {
            if ((k = in.read(buffer)) <= 0) continue;
            out.write(buffer, 0, k);
            written += (long)k;
        } while (k >= 0);
        return written;
    }

    public static boolean equalStreams(InputStream in, InputStream in2) throws IOException {
        boolean ok = true;
        byte[] buffer = new byte[32768];
        byte[] buffer2 = new byte[32768];
        int k = 0;
        int k2 = 0;
        do {
            k = in.read(buffer);
            k2 = in2.read(buffer2);
            boolean bl = ok = ok && k == k2;
            if (k <= 0) continue;
            boolean bl2 = ok = ok && Arrays.equals(buffer, buffer2);
        } while (k >= 0);
        return ok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void printOutFile(File rcPropFile) throws IOException {
        FileInputStream fileInputStream = new FileInputStream(rcPropFile);
        InputStreamReader reader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line = null;
            do {
                line = bufferedReader.readLine();
                System.out.println(line);
            } while (null != line);
        }
        finally {
            bufferedReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertInputStreamToString(InputStream inputStream) throws IOException {
        if (inputStream != null) {
            StringBuilder stringBuilder = new StringBuilder();
            try {
                String line;
                BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                while ((line = reader.readLine()) != null) {
                    stringBuilder.append(line).append("\n");
                }
            }
            finally {
                inputStream.close();
            }
            return stringBuilder.toString();
        }
        return null;
    }
}

