/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.OSInformations;
import de.mcs.utils.StreamReaderThread;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class StartProcess {
    private StartProcess() {
    }

    public static int startJava(List<String> command, boolean wait, String workingDir) {
        Runtime rt = Runtime.getRuntime();
        File workingDirFile = new File(workingDir);
        int result = 0;
        try {
            Process p = rt.exec(command.toArray(new String[command.size()]), null, workingDirFile);
            StreamReaderThread outThread = new StreamReaderThread(p.getInputStream(), System.out);
            StreamReaderThread errThread = new StreamReaderThread(p.getErrorStream(), System.err);
            outThread.start();
            errThread.start();
            if (wait) {
                result = p.waitFor();
                outThread.join();
                errThread.join();
                if (result != 0) {
                    System.err.println("Process " + command.get(0) + " returned non-zero value:" + result);
                } else {
                    System.out.println("Process " + command.get(0) + " executed successfully");
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static int changeFilePermissions(File file) {
        int result = 0;
        if (OSInformations.isMACOSX()) {
            ArrayList<String> command = new ArrayList<String>();
            command.add("chmod");
            command.add("755");
            command.add(file.getAbsolutePath());
            result = StartProcess.startJava(command, true, file.getParent());
        }
        return result;
    }
}

