/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class SoftHashMap<K, V>
extends AbstractMap<K, V> {
    private Map<K, Reference<V>> m = null;
    private ReferenceQueue q = new ReferenceQueue();
    private Set entrySet = null;

    public SoftHashMap() {
        this.m = new HashMap<K, Reference<V>>();
    }

    public SoftHashMap(int initialCapacity) {
        this.m = new HashMap<K, Reference<V>>(initialCapacity);
    }

    public SoftHashMap(int initialCapacity, float loadFactor) {
        this.m = new HashMap<K, Reference<V>>(initialCapacity, loadFactor);
    }

    @Override
    public final V get(Object key) {
        Reference<V> res = this.m.get(key);
        return res == null ? null : (V)res.get();
    }

    @Override
    public final V put(K key, V value) {
        this.processQueue();
        SoftEntry ref = new SoftEntry(key, value, this.q);
        Reference res = this.m.put(key, ref);
        return res == null ? null : (V)res.get();
    }

    @Override
    public final Set entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    private void processQueue() {
        Reference r;
        while ((r = this.q.poll()) != null) {
            SoftEntry e = (SoftEntry)r;
            this.m.remove(e.key);
        }
    }

    @Override
    public final int size() {
        return this.entrySet().size();
    }

    @Override
    public final V remove(Object key) {
        this.processQueue();
        Reference<V> res = this.m.remove(key);
        return res == null ? null : (V)res.get();
    }

    @Override
    public final void clear() {
        this.processQueue();
        this.m.clear();
    }

    private class EntrySet<E>
    extends AbstractSet<E> {
        private Set entrySet;

        private EntrySet() {
            this.entrySet = SoftHashMap.this.m.entrySet();
        }

        @Override
        public int size() {
            int s = 0;
            Iterator<E> i = this.iterator();
            while (i.hasNext()) {
                ++s;
                i.next();
            }
            return s;
        }

        @Override
        public boolean isEmpty() {
            return !this.iterator().hasNext();
        }

        @Override
        public boolean remove(Object o) {
            SoftHashMap.this.processQueue();
            return super.remove(o);
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator(){
                private Iterator it;
                private Map.Entry next;
                private Object value;
                {
                    this.it = EntrySet.this.entrySet.iterator();
                    this.next = null;
                    this.value = null;
                }

                @Override
                public boolean hasNext() {
                    while (this.it.hasNext()) {
                        final Map.Entry e = (Map.Entry)this.it.next();
                        SoftEntry se = (SoftEntry)e.getValue();
                        this.value = null;
                        if (se != null && (this.value = se.get()) == null) continue;
                        this.next = new Map.Entry(){

                            public Object getKey() {
                                return e.getKey();
                            }

                            public Object getValue() {
                                return value;
                            }

                            public Object setValue(Object v) {
                                Object res = value;
                                value = v;
                                e.setValue(new SoftEntry(e.getKey(), value, SoftHashMap.this.q));
                                return res;
                            }

                            @Override
                            public boolean equals(Object x) {
                                if (!(x instanceof Map.Entry)) {
                                    return false;
                                }
                                Map.Entry e2 = (Map.Entry)x;
                                Object key = this.getKey();
                                return key == null ? e2.getKey() == null : (key.equals(e2.getKey()) && value == null ? e2.getValue() == null : value.equals(e2.getValue()));
                            }

                            @Override
                            public int hashCode() {
                                Object key = this.getKey();
                                return (key == null ? 0 : key.hashCode()) ^ (value == null ? 0 : value.hashCode());
                            }
                        };
                        return true;
                    }
                    return false;
                }

                public Object next() {
                    if (this.next == null && !this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Map.Entry e = this.next;
                    this.next = null;
                    return e;
                }

                @Override
                public void remove() {
                    this.it.remove();
                }
            };
        }
    }

    private static final class SoftEntry<K, T>
    extends SoftReference<T> {
        private K key;

        private SoftEntry(K aKey, T value, ReferenceQueue q) {
            super(value, q);
            this.key = aKey;
        }
    }
}

