/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Properties;
import java.util.TreeSet;

public class PropertiesHelper
extends Properties {
    private static final long serialVersionUID = -3239128704806211452L;
    private static final char[] HEXDIGIT = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public final String[] getKeys(String regex) {
        ArrayList<String> list = new ArrayList<String>();
        for (String string : this.keySet()) {
            if (!string.matches(regex)) continue;
            list.add(string);
        }
        return list.toArray(new String[0]);
    }

    public final Properties extractProperties(String keyPrefix) {
        Properties mediaProps = new Properties();
        String[] mediaKeyNames = this.getKeys(keyPrefix + ".*");
        for (int j = 0; j < mediaKeyNames.length; ++j) {
            String key = mediaKeyNames[j];
            String value = this.getProperty(key);
            key = key.substring(key.indexOf(keyPrefix + ".") + (keyPrefix + ".").length());
            mediaProps.setProperty(key, value);
        }
        return mediaProps;
    }

    public final void storeSorted(OutputStream out, String comments) throws IOException {
        BufferedWriter awriter = new BufferedWriter(new OutputStreamWriter(out, "8859_1"));
        if (comments != null) {
            PropertiesHelper.writeln(awriter, "#" + comments);
        }
        PropertiesHelper.writeln(awriter, "#" + new Date().toString());
        TreeSet<Object> mySet = new TreeSet<Object>(new Comparator<Object>(){

            @Override
            public int compare(Object o1, Object o2) {
                if (o1 instanceof String && o2 instanceof String) {
                    String s1 = (String)o1;
                    String s2 = (String)o2;
                    return s1.compareTo(s2);
                }
                return 0;
            }
        });
        mySet.addAll(this.keySet());
        for (String string : mySet) {
            String val = (String)this.get(string);
            String string2 = this.saveConvert(string, true);
            val = this.saveConvert(val, false);
            PropertiesHelper.writeln(awriter, string2 + "=" + val);
        }
        awriter.flush();
    }

    private static void writeln(BufferedWriter bw, String s) throws IOException {
        bw.write(s);
        bw.newLine();
    }

    private String saveConvert(String theString, boolean escapeSpace) {
        int len = theString.length();
        int bufLen = len * 2;
        if (bufLen < 0) {
            bufLen = Integer.MAX_VALUE;
        }
        StringBuffer outBuffer = new StringBuffer(bufLen);
        block8: for (int x = 0; x < len; ++x) {
            char aChar = theString.charAt(x);
            if (aChar > '=' && aChar < '\u007f') {
                if (aChar == '\\') {
                    outBuffer.append('\\');
                    outBuffer.append('\\');
                    continue;
                }
                outBuffer.append(aChar);
                continue;
            }
            switch (aChar) {
                case ' ': {
                    if (x == 0 || escapeSpace) {
                        outBuffer.append('\\');
                    }
                    outBuffer.append(' ');
                    continue block8;
                }
                case '\t': {
                    outBuffer.append('\\');
                    outBuffer.append('t');
                    continue block8;
                }
                case '\n': {
                    outBuffer.append('\\');
                    outBuffer.append('n');
                    continue block8;
                }
                case '\r': {
                    outBuffer.append('\\');
                    outBuffer.append('r');
                    continue block8;
                }
                case '\f': {
                    outBuffer.append('\\');
                    outBuffer.append('f');
                    continue block8;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': {
                    outBuffer.append('\\');
                    outBuffer.append(aChar);
                    continue block8;
                }
                default: {
                    if (aChar < ' ' || aChar > '~') {
                        outBuffer.append('\\');
                        outBuffer.append('u');
                        outBuffer.append(PropertiesHelper.toHex(aChar >> 12 & 0xF));
                        outBuffer.append(PropertiesHelper.toHex(aChar >> 8 & 0xF));
                        outBuffer.append(PropertiesHelper.toHex(aChar >> 4 & 0xF));
                        outBuffer.append(PropertiesHelper.toHex(aChar & 0xF));
                        continue block8;
                    }
                    outBuffer.append(aChar);
                }
            }
        }
        return outBuffer.toString();
    }

    private static char toHex(int nibble) {
        return HEXDIGIT[nibble & 0xF];
    }
}

