/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.IOException;
import java.net.Socket;
import java.util.ArrayList;

public class PortTest
extends Thread {
    private String server;
    private int port;
    private boolean result;

    public PortTest(String server, int port) {
        this.server = server;
        this.port = port;
    }

    public void setServer(String param) {
        this.server = param;
    }

    public String getServer() {
        return this.server;
    }

    public void setPort(int param) {
        this.port = param;
    }

    public int getPort() {
        return this.port;
    }

    public boolean checkPortWithoutPing() {
        long timeStart = System.currentTimeMillis();
        boolean success = false;
        try {
            Socket s = new Socket(this.server, this.port);
            s.close();
            success = true;
        }
        catch (IOException e) {
            success = false;
        }
        long timeEnd = System.currentTimeMillis();
        return success;
    }

    public boolean checkPortWithPing() {
        long timeStart = System.currentTimeMillis();
        boolean success = false;
        success = this.pingServer() ? this.checkPortWithoutPing() : false;
        long timeEnd = System.currentTimeMillis();
        System.out.println("Portcheck w ping: " + (timeEnd - timeStart));
        return success;
    }

    private boolean isLinux() {
        return !System.getProperty("os.name").toLowerCase().contains("windows");
    }

    public boolean pingServer() {
        Process p;
        long timeStart = System.currentTimeMillis();
        boolean success = false;
        ProcessBuilder pb = null;
        pb = new ProcessBuilder(new String[0]);
        String[] cmd = null;
        cmd = this.isLinux() ? new String[]{"ping", "-c", "1", this.server} : new String[]{"ping", "-w", "250", "-n", "1", this.server};
        pb.command(cmd);
        try {
            p = pb.start();
        }
        catch (IOException e) {
            return success;
        }
        if (p != null) {
            try {
                p.waitFor();
                success = p.exitValue() == 0;
            }
            catch (InterruptedException e) {
                success = false;
            }
        }
        long timeEnd = System.currentTimeMillis();
        System.out.println("Ping: " + (timeEnd - timeStart));
        return success;
    }

    public static void main(String[] args) {
        Object portcheck = null;
        ArrayList<String> results = new ArrayList<String>();
        for (int x = 0; x < 65000; ++x) {
            ArrayList<PortTest> list = new ArrayList<PortTest>();
            for (int i = 0; i < 100; ++i) {
                PortTest porttest = new PortTest("127.0.0.1", i + x * 100);
                porttest.start();
                list.add(porttest);
            }
            for (PortTest test : list) {
                while (test.isAlive()) {
                }
                if (!test.getResult()) continue;
                results.add("Port " + test.getPort() + " is open.");
            }
            for (String string : results) {
                System.out.println(string);
            }
            results.clear();
        }
    }

    @Override
    public void run() {
        this.result = this.checkPortWithoutPing();
    }

    public boolean getResult() {
        return this.result;
    }

    public static int nextFreePort(int min, int max) {
        for (int x = min; x <= max; ++x) {
            PortTest porttest = new PortTest("127.0.0.1", x);
            porttest.start();
            while (porttest.isAlive()) {
                try {
                    PortTest.sleep(500L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    return -1;
                }
            }
            if (porttest.getResult()) continue;
            return x;
        }
        return -1;
    }
}

