/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class NamedList {
    private Map<String, String> list = new HashMap<String, String>();

    public void add(String key, String value) {
        this.list.put(key, value);
    }

    public String get(String key) {
        return this.list.get(key);
    }

    public String remove(String key) {
        return this.list.remove(key);
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry<String, String> entry : this.list.entrySet()) {
            b.append(entry.getKey());
            b.append("=");
            try {
                if (entry.getValue() != null) {
                    b.append(URLEncoder.encode(entry.getValue(), "UTF-8"));
                }
            }
            catch (UnsupportedEncodingException e) {
                // empty catch block
            }
            b.append(";");
        }
        return b.substring(0, b.length() - 1).toString();
    }

    public void parseString(String line) {
        String[] keyValues;
        for (String entry : keyValues = line.split(";")) {
            String[] entryValues;
            if (entry == null || entry.equals("") || (entryValues = entry.split("=")).length <= 0) continue;
            String key = entryValues[0];
            String value = null;
            if (entryValues.length > 1) {
                try {
                    value = URLDecoder.decode(entryValues[1], "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    // empty catch block
                }
            }
            this.add(key, value);
        }
    }

    public static void main(String[] args) {
        NamedList list = new NamedList();
        list.add("test1", "test1");
        list.add("test2", "test;:#'+*!\"\u00a7$%&/()=");
        System.out.println(list.toString());
        NamedList list2 = new NamedList();
        list2.parseString(list.toString());
        System.out.println(list2.toString());
    }
}

