/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.StringUtils;
import java.util.Locale;
import java.util.Map;

public class MacroReplacer {
    private Locale locale;

    public MacroReplacer(Locale locale) {
        this.locale = locale;
    }

    public String replace(String source, Map<String, String> replaceMap) {
        String sourceStr = source;
        int pos = sourceStr.indexOf("${");
        while (pos >= 0) {
            String left = sourceStr.substring(0, pos);
            int endpos = sourceStr.indexOf("}", pos);
            String macro = sourceStr.substring(pos + 2, endpos);
            if (replaceMap.containsKey(macro) && (macro = replaceMap.get(macro)).contains(",")) {
                Map<String, String> localeStrings = StringUtils.csvStringToPropMap(macro, ',', '\"', ':');
                if (localeStrings.containsKey("default")) {
                    macro = localeStrings.get("default");
                }
                if (localeStrings.containsKey(this.locale.getLanguage())) {
                    macro = localeStrings.get(this.locale.getLanguage());
                }
            }
            String right = sourceStr.substring(endpos + 1);
            sourceStr = left + macro + right;
            pos = sourceStr.indexOf("${");
        }
        return sourceStr;
    }
}

