/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import java.io.StringWriter;
import java.net.URLDecoder;
import java.net.URLEncoder;

public class HTMLEncoder {
    private static final char[] c = new char[]{'<', '>', '&', '\"'};
    private static final String[] expansion = new String[]{"&lt;", "&gt;", "&amp;", "&quot;"};

    public static String HTMLEncode(String s) {
        if (s == null) {
            return null;
        }
        StringBuffer st = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            boolean copy = true;
            char ch = s.charAt(i);
            for (int j = 0; j < c.length; ++j) {
                if (c[j] != ch) continue;
                st.append(expansion[j]);
                copy = false;
                break;
            }
            if (!copy) continue;
            st.append(ch);
        }
        return st.toString();
    }

    public static String encode(String string) {
        if (string == null) {
            return null;
        }
        char[] chars = string.toCharArray();
        StringWriter output = new StringWriter();
        int last = 0;
        int length = chars.length;
        block8: for (int counter = 0; counter < length; ++counter) {
            switch (chars[counter]) {
                case '<': {
                    if (counter > last) {
                        output.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    output.write("&lt;");
                    continue block8;
                }
                case '>': {
                    if (counter > last) {
                        output.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    output.write("&gt;");
                    continue block8;
                }
                case '&': {
                    if (counter > last) {
                        output.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    output.write("&amp;");
                    continue block8;
                }
                case '\"': {
                    if (counter > last) {
                        output.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    output.write("&quot;");
                    continue block8;
                }
                case '\n': {
                    if (counter > last) {
                        output.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    output.write("<br/>");
                    continue block8;
                }
                case '\t': 
                case '\r': {
                    continue block8;
                }
                default: {
                    if (chars[counter] >= ' ' && chars[counter] <= '\u007f') continue block8;
                    if (counter > last) {
                        output.write(chars, last, counter - last);
                    }
                    last = counter + 1;
                    output.write("&#");
                    output.write(String.valueOf((int)chars[counter]));
                    output.write(";");
                }
            }
        }
        if (last < length) {
            output.write(chars, last, length - last);
        }
        return output.toString();
    }

    public static String URLEncode(String string) {
        if (string == null) {
            return null;
        }
        return URLEncoder.encode(string);
    }

    public static String URLDencode(String string) {
        if (string == null) {
            return null;
        }
        return URLDecoder.decode(string);
    }

    public static String stringToHTMLString(String string) {
        StringBuffer sb = new StringBuffer(string.length());
        boolean lastWasBlankChar = false;
        int len = string.length();
        for (int i = 0; i < len; ++i) {
            char c = string.charAt(i);
            if (c == ' ') {
                if (lastWasBlankChar) {
                    lastWasBlankChar = false;
                    sb.append("&nbsp;");
                    continue;
                }
                lastWasBlankChar = true;
                sb.append(' ');
                continue;
            }
            lastWasBlankChar = false;
            if (c == '\"') {
                sb.append("&quot;");
                continue;
            }
            if (c == '&') {
                sb.append("&amp;");
                continue;
            }
            if (c == '<') {
                sb.append("&lt;");
                continue;
            }
            if (c == '>') {
                sb.append("&gt;");
                continue;
            }
            if (c == '\r') continue;
            if (c == '\n') {
                sb.append("<br/>");
                continue;
            }
            int ci = 0xFFFF & c;
            if (ci < 160) {
                sb.append(c);
                continue;
            }
            sb.append("&#");
            sb.append(new Integer(ci).toString());
            sb.append(';');
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        System.out.println(HTMLEncoder.stringToHTMLString(" abcdefghijklmnopqrstuvwxyz\u00fc\u00e4\u00f6\u00dc\u00c4\u00d6\u00df<>;&%$\u00a7\r\n \n"));
    }
}

