/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.StreamHelper;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class Files {
    private static int searchDepth = 0;

    private Files() {
    }

    public static String getTempFileName(String pre, String suf, String dir) throws IOException {
        File f = File.createTempFile(pre, suf, new File(dir));
        String filename = f.getAbsolutePath();
        return filename;
    }

    public static String getTempPath() {
        String strTempPath = null;
        strTempPath = System.getProperty("java.io.tmpdir");
        if (!strTempPath.endsWith(File.separator)) {
            return strTempPath + File.separator;
        }
        return strTempPath;
    }

    public static File createTempDirectory(File parentPath) throws IOException {
        int count = 0;
        File folder = null;
        do {
            String foldername = new DecimalFormat("0000").format(count);
            folder = new File(parentPath, foldername);
            ++count;
        } while (folder.exists());
        if (!folder.mkdir()) {
            throw new IOException("Could not create temp directory: " + folder.getAbsolutePath());
        }
        return folder;
    }

    public static String formatFileNameToBlobName(String filename) {
        String sFilename = filename;
        sFilename = sFilename.replaceAll("[^0-9a-zA-Z]", "_");
        sFilename = sFilename.replace('.', '_');
        return sFilename;
    }

    @Deprecated
    public static String computeMD5FromFile(String file) {
        return Files.computeMD5FromFile(new File(file));
    }

    public static byte[] computeMD5BytesFromFile(File file) {
        BufferedInputStream in = null;
        MessageDigest digest = null;
        try {
            in = new BufferedInputStream(new FileInputStream(file));
            try {
                digest = MessageDigest.getInstance("MD5");
                byte[] array = new byte[32768];
                int length = 0;
                try {
                    while (length >= 0) {
                        length = ((InputStream)in).read(array);
                        if (length <= 0) continue;
                        digest.update(array, 0, length);
                    }
                    ((InputStream)in).close();
                    return digest.digest();
                }
                catch (IOException e) {
                    System.err.println("error reading " + file + "(" + e.getMessage() + ")");
                }
            }
            catch (NoSuchAlgorithmException e) {
                System.err.println("md5 not implemented");
            }
        }
        catch (FileNotFoundException e) {
            System.err.println("File " + file + " not found");
        }
        return null;
    }

    public static String computeMD5FromFile(File file) {
        String sMD5 = "";
        byte[] md5 = Files.computeMD5BytesFromFile(file);
        for (int l = 0; l < md5.length; ++l) {
            int i = md5[l] >= 0 ? md5[l] : 256 + md5[l];
            String s = Integer.toHexString(i);
            while (s.length() < 2) {
                s = "0" + s;
            }
            sMD5 = sMD5 + s;
        }
        return sMD5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void fileCopy(File src, File destIn, boolean keepDate) throws IOException {
        File dest = destIn;
        if (destIn.isDirectory()) {
            dest = new File(destIn, src.getName());
        }
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileInputStream fin = null;
        FileOutputStream fout = null;
        AbstractInterruptibleChannel fchIn = null;
        AbstractInterruptibleChannel fchOut = null;
        try {
            fin = new FileInputStream(src);
            fout = new FileOutputStream(dest);
            fchIn = fin.getChannel();
            fchOut = fout.getChannel();
            long position = 0L;
            long remaining = ((FileChannel)fchIn).size();
            ((FileChannel)fchOut).position(0L);
            ((FileChannel)fchIn).position(0L);
            while (remaining > 0L) {
                long transferred = ((FileChannel)fchOut).transferFrom((ReadableByteChannel)((Object)fchIn), position, remaining);
                remaining -= transferred;
                position += transferred;
            }
        }
        finally {
            if (null != fchOut) {
                fchOut.close();
            }
            if (null != fchIn) {
                fchIn.close();
            }
            if (null != fout) {
                fout.close();
            }
            if (null != fin) {
                fin.close();
            }
        }
        if (keepDate) {
            dest.setLastModified(src.lastModified());
        }
    }

    public static void fileCopy(File src, File dest) throws IOException {
        Files.fileCopy(src, dest, false);
    }

    public static File[] getFiles(File baseDir, boolean recursive) {
        return Files.getFiles(baseDir, recursive, false);
    }

    public static File[] getFiles(File baseDir, boolean recursive, boolean excludeDotFiles) {
        ArrayList<File> fileList = new ArrayList<File>();
        File[] files = baseDir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                if (file.isDirectory()) {
                    if (excludeDotFiles && file.getName().startsWith(".")) continue;
                    File[] newFiles = Files.getFiles(file, recursive, excludeDotFiles);
                    for (int j = 0; j < newFiles.length; ++j) {
                        fileList.add(newFiles[j]);
                    }
                    continue;
                }
                if (!file.isFile() || excludeDotFiles && file.getName().startsWith(".")) continue;
                fileList.add(file);
            }
        }
        return fileList.toArray(new File[0]);
    }

    public static void fileCopy(File[] files, File installSiteDir) throws IOException {
        for (int i = 0; i < files.length; ++i) {
            File srcFile = files[i];
            File destFile = new File(installSiteDir, srcFile.getName());
            Files.fileCopy(srcFile, destFile);
        }
    }

    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        if (!success) {
            System.err.println("Directory [" + directory + "] creation failed !");
        }
        return success;
    }

    public static boolean createDirectories(String directory) {
        boolean success = new File(directory).mkdirs();
        if (!success) {
            System.err.println("Directory [" + directory + "] creation failed !");
        }
        return success;
    }

    public static boolean createDirectoryStructure(String aDirectory, String[] subdirectories) {
        String directory = aDirectory;
        boolean success = true;
        if (!Files.fileExists(directory = Files.eliminateDoubleSlashes(directory)) && !Files.createDirectories(directory)) {
            return false;
        }
        if (!directory.endsWith("/")) {
            directory = directory + '/';
        }
        for (int iLoop = 0; iLoop < subdirectories.length; ++iLoop) {
            File subDir = new File(directory + subdirectories[iLoop]);
            if (subDir.exists() || Files.createDirectory(directory + subdirectories[iLoop])) continue;
            success = false;
            break;
        }
        if (!success) {
            System.err.println("Directory [" + directory + "] creation failed !");
        }
        return success;
    }

    @Deprecated
    public static boolean move(String source, String destination) {
        try {
            return new File(source).renameTo(new File(destination));
        }
        catch (SecurityException e) {
            System.err.println("The file " + source + " could not moved to " + destination + " : " + e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean move(File source, File destination) {
        try {
            return source.renameTo(destination);
        }
        catch (SecurityException e) {
            System.err.println("The file " + source + " could not moved to " + destination + " : " + e.getLocalizedMessage());
            return false;
        }
    }

    @Deprecated
    public static boolean copy(String source, String destination) {
        searchDepth = 0;
        return Files.filecopy(source, destination, true);
    }

    @Deprecated
    public static boolean copy(String source, String destination, boolean subdirectories) {
        searchDepth = 0;
        return Files.filecopy(source, destination, subdirectories);
    }

    protected static boolean filecopy(String source, String destination, boolean subdirectories) {
        boolean success;
        block13: {
            File sourceDir;
            String path;
            File dest;
            int bSlash;
            File sourceFile;
            block14: {
                success = true;
                sourceFile = new File(source);
                if (!sourceFile.isDirectory()) break block14;
                if (searchDepth++ > 0 && !subdirectories) {
                    return true;
                }
                if (!Files.fileExists(destination)) {
                    Files.createDirectories(destination);
                }
                String[] subFiles = sourceFile.list();
                for (int iLoop = 0; iLoop < subFiles.length; ++iLoop) {
                    Files.filecopy(source + File.separator + subFiles[iLoop], destination + File.separator + subFiles[iLoop], subdirectories);
                }
                break block13;
            }
            int fSlash = destination.lastIndexOf("/");
            int slash = fSlash > (bSlash = destination.lastIndexOf("\\")) ? fSlash : bSlash;
            if (slash > -1 && !(dest = new File(path = destination.substring(0, slash))).exists()) {
                Files.createDirectories(path);
            }
            File[] inputFiles = new File[]{sourceFile};
            String mask = sourceFile.getName();
            if (FileIncludes.isMask(mask) && null != (sourceDir = sourceFile.getParentFile()) && mask.length() > 0) {
                try {
                    FileIncludes filter = new FileIncludes(sourceDir, mask);
                    inputFiles = sourceDir.listFiles(filter);
                }
                catch (PatternSyntaxException e) {
                    // empty catch block
                }
            }
            File destFile = new File(destination);
            if (null == inputFiles) break block13;
            if (destFile.isFile() && inputFiles.length > 1) {
                System.err.println("For copying multiple files to the destination \"" + destination + "\" it must be a directory and NOT A SINGLE file.");
                success = false;
            } else {
                for (int idx = 0; idx < inputFiles.length; ++idx) {
                    File inputFile = inputFiles[idx];
                    File destinationFile = destFile.isDirectory() ? new File(destFile, inputFile.getName()) : destFile;
                    try {
                        Files.fileCopy(inputFile, destinationFile, true);
                        success = true;
                        continue;
                    }
                    catch (FileNotFoundException eFNF) {
                        System.err.println("The source file could not be found. " + eFNF);
                        System.err.println("Tried to copy " + inputFile + " to " + destinationFile + " : " + eFNF);
                        success = false;
                        break;
                    }
                    catch (IOException eIO) {
                        System.err.println("IOException occured while copying file.");
                        System.err.println("Tried to copy " + inputFile + " to " + destinationFile + " : " + eIO);
                        success = false;
                        break;
                    }
                }
            }
        }
        return success;
    }

    public static File getAbsoluteFile(String filename) {
        File file = new File(filename).getAbsoluteFile();
        if (".".equals(file.getName())) {
            file = file.getParentFile();
        } else if ("..".equals(file.getName()) && null != (file = file.getParentFile())) {
            file = file.getParentFile();
        }
        return file;
    }

    public static String makeDirectory(String aPath) {
        String path = aPath;
        String separatorChar = System.getProperty("file.separator");
        if (path != null && !path.endsWith(separatorChar)) {
            path = path + separatorChar;
        }
        return path;
    }

    @Deprecated
    public static boolean remove(String filename, boolean bRecursive) throws IOException {
        return Files.remove(filename, bRecursive, null);
    }

    public static boolean remove(File file, boolean bRecursive) throws IOException {
        return Files.remove(file, bRecursive, null);
    }

    @Deprecated
    public static boolean remove(String filename, boolean bRecursive, List<String> excludes) throws IOException {
        boolean bSuccess = true;
        if (filename != null && 0 != filename.length()) {
            File file = new File(filename);
            if (file.isDirectory()) {
                String[] files = file.list();
                if (!bRecursive && files.length > 0) {
                    System.err.println();
                    throw new IOException("Directory " + file.getAbsolutePath() + " is not Empty");
                }
                for (int iLoop = 0; iLoop < files.length; ++iLoop) {
                    String toRemove = Files.convertSlashes(file.getAbsolutePath() + "/" + files[iLoop]);
                    if (Files.isExcluded(toRemove, excludes) || Files.remove(toRemove, true)) continue;
                    bSuccess = false;
                }
                if (bSuccess && !Files.isExcluded(filename, excludes)) {
                    bSuccess = Files.remove(filename);
                }
            } else if (!Files.isExcluded(filename, excludes)) {
                bSuccess = Files.remove(filename);
            }
        }
        return bSuccess;
    }

    public static boolean remove(File source, boolean bRecursive, List<String> excludes) throws IOException {
        boolean bSuccess = true;
        if (source != null && source.exists()) {
            if (source.isDirectory()) {
                File[] files = source.listFiles();
                if (!bRecursive && files.length > 0) {
                    System.err.println();
                    throw new IOException("Directory " + source.getAbsolutePath() + " is not Empty");
                }
                for (int iLoop = 0; iLoop < files.length; ++iLoop) {
                    File file = files[iLoop];
                    if (Files.isExcluded(file, excludes) || Files.remove(file, true)) continue;
                    bSuccess = false;
                }
                if (bSuccess && !Files.isExcluded(source, excludes)) {
                    bSuccess = source.delete();
                }
            } else if (!Files.isExcluded(source, excludes)) {
                bSuccess = source.delete();
            }
        }
        return bSuccess;
    }

    @Deprecated
    private static boolean isExcluded(String filename, List<String> excludes) {
        boolean bDelete = true;
        if (excludes != null && excludes.size() > 0) {
            for (int iFileLoop = 0; iFileLoop < excludes.size(); ++iFileLoop) {
                String exclude = Files.convertSlashes(excludes.get(iFileLoop));
                if (filename.indexOf(exclude) <= -1 && !exclude.startsWith(filename)) continue;
                bDelete = false;
                break;
            }
        }
        return !bDelete;
    }

    private static boolean isExcluded(File file, List<String> excludes) {
        boolean bDelete = true;
        if (excludes != null && excludes.size() > 0) {
            for (int i = 0; i < excludes.size(); ++i) {
                String exclude = Files.convertSlashes(excludes.get(i));
                try {
                    if (file.getCanonicalPath().indexOf(exclude) <= -1 && !exclude.startsWith(file.getCanonicalPath())) continue;
                    bDelete = false;
                    break;
                }
                catch (IOException e) {
                    bDelete = false;
                }
            }
        }
        return !bDelete;
    }

    @Deprecated
    public static boolean remove(String filename) {
        try {
            return new File(filename).delete();
        }
        catch (SecurityException e) {
            System.err.println("The file " + filename + " could not be removed: " + e.getLocalizedMessage());
            return false;
        }
    }

    public static List<String> readFileToList(String fileName) throws IOException {
        return Files.readFileToList(new File(fileName));
    }

    public static List<String> readFileToList(File file) throws IOException {
        return Files.readFileToList(file, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileToList(File file, boolean comments) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0 || line.trim().charAt(0) == '#' && comments) continue;
                list.add(line);
            }
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    @Deprecated
    public static void writeListToFile(String fileName, List<String> list) throws IOException {
        Files.writeListToFile(new File(fileName), list);
    }

    public static void writeListToFile(File file, List<String> list) throws IOException {
        PrintWriter br = null;
        br = new PrintWriter(new BufferedWriter(new FileWriter(file)));
        for (String entry : list) {
            br.println(entry.toString());
        }
        br.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static String readFileToString(String fileName) {
        StringBuilder buffer = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            System.err.println("The File " + fileName + " could not be found !!");
            e.printStackTrace();
            System.exit(3);
        }
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                buffer.append(line);
                buffer.append("\r\n");
            }
        }
        catch (IOException e1) {
            System.err.println("IOException occured while reading " + fileName + "");
            e1.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(File file) {
        StringBuilder buffer = new StringBuilder();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(file)));
        }
        catch (FileNotFoundException e) {
            System.err.println("The File " + file + " could not be found !!");
            e.printStackTrace();
            System.exit(3);
        }
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0) continue;
                buffer.append(line);
                buffer.append("\r\n");
            }
        }
        catch (IOException e1) {
            System.err.println("IOException occured while reading " + file + "");
            e1.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public static String readFile(File file) throws IOException {
        BufferedInputStream br = null;
        br = new BufferedInputStream(new FileInputStream(file));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        StreamHelper.copyStream(br, out);
        br.close();
        return new String(out.toByteArray());
    }

    @Deprecated
    public static void writeStringToFile(String filename, String content) {
        File file = new File(filename);
        try {
            Files.writeStringToFile(file, content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void writeStringToFile(File file, String content) throws IOException {
        BufferedWriter bufWriter = new BufferedWriter(new FileWriter(file));
        bufWriter.write(content);
        bufWriter.close();
    }

    public static String eliminateDoubleSlashes(String filename) {
        String result = "";
        result = filename.indexOf(":") == -1 && filename.startsWith("//") ? filename.substring(0, 2) + filename.substring(2).replaceAll("//", "/") : filename.replaceAll("//", "/");
        return result;
    }

    public static String convertSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String convertBackSlashes(String path) {
        return path.replaceAll("/", "\\\\");
    }

    public static String convertBackSlashesNoParams(String aPath) {
        String path = aPath;
        int slash = -1;
        while ((slash = path.indexOf("/", slash + 1)) > -1) {
            if (slash <= -1 || path.charAt(slash - 1) == ' ') continue;
            String sLineStart = path.substring(0, slash);
            String sLineEnd = path.substring(slash + 1);
            path = sLineStart + "\\" + sLineEnd;
        }
        return path;
    }

    public static String normPath(String aPath) {
        if (!aPath.endsWith("/") && !aPath.endsWith("\\")) {
            return aPath + File.separator;
        }
        return aPath;
    }

    public static String getExtension(File file) {
        if (file.isFile()) {
            String name = file.getName();
            if (name.indexOf(46) >= 0) {
                return name.substring(name.lastIndexOf("."));
            }
            return "";
        }
        return null;
    }

    public static String getExtension(String name) {
        return name.substring(name.lastIndexOf("."));
    }

    public static String extractName(File file) {
        if (file.isFile()) {
            String name = file.getName();
            if (name.lastIndexOf(".") >= 0) {
                return name.substring(0, name.lastIndexOf("."));
            }
            return name;
        }
        String name = file.getName();
        if (name.indexOf(".") >= 0) {
            return name.substring(0, name.lastIndexOf("."));
        }
        return name;
    }

    public static File changeExtension(File file, String newExtension) {
        return new File(file.getParentFile(), Files.extractName(file) + newExtension);
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "KB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    public static String getDriveLetter(File file) throws IOException {
        String canonicalPath = file.getCanonicalPath();
        canonicalPath = canonicalPath.substring(0, 2);
        return canonicalPath;
    }

    public static File getAppData() {
        String appDataStr = System.getenv("APPDATA");
        if ((appDataStr == null || appDataStr.equals("")) && ((appDataStr = System.getenv("LOCALAPPDATA")) == null || appDataStr.equals(""))) {
            appDataStr = Files.getTempPath();
        }
        return new File(appDataStr);
    }

    static class FileIncludes
    implements FilenameFilter {
        private File dir;
        private Pattern mask;
        private static String regexpSpecChars = ".\\$^()[]+";

        private static boolean isMask(String mask) {
            int pos = mask.indexOf(42);
            if (pos < 0) {
                pos = mask.indexOf(63);
            }
            return pos >= 0;
        }

        String toRegExp(String aMask) {
            StringBuffer sb = new StringBuffer();
            int length = aMask.length();
            for (int index = 0; index < length; ++index) {
                char ch = aMask.charAt(index);
                if (ch == '*') {
                    sb.append(".*");
                    continue;
                }
                if (ch == '?') {
                    sb.append(".+");
                    continue;
                }
                if (regexpSpecChars.indexOf(ch) >= 0) {
                    sb.append('\\').append(ch);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public FileIncludes(File aDir, String aMask) {
            this.dir = aDir;
            this.mask = Pattern.compile(this.toRegExp(aMask));
        }

        @Override
        public boolean accept(File aDir, String name) {
            if (aDir.equals(this.dir)) {
                boolean matches = this.mask.matcher(name).matches();
                return matches;
            }
            return false;
        }
    }
}

