/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.Files;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public final class FileTool {
    private static int searchDepth = 0;

    private FileTool() {
    }

    public static boolean fileExists(String fileName) {
        return new File(fileName).exists();
    }

    public static boolean createDirectory(String directory) {
        boolean success = new File(directory).mkdir();
        if (!success) {
            System.err.println("Directory [" + directory + "] creation failed !");
        }
        return success;
    }

    public static boolean createDirectories(String directory) {
        boolean success = new File(directory).mkdirs();
        if (!success) {
            System.err.println("Directory [" + directory + "] creation failed !");
        }
        return success;
    }

    public static boolean createDirectoryStructure(String aDirectory, String[] subdirectories) {
        String directory = aDirectory;
        boolean success = true;
        if (!FileTool.fileExists(directory = FileTool.eliminateDoubleSlashes(directory)) && !FileTool.createDirectories(directory)) {
            return false;
        }
        if (!directory.endsWith("/")) {
            directory = directory + '/';
        }
        for (int iLoop = 0; iLoop < subdirectories.length; ++iLoop) {
            File subDir = new File(directory + subdirectories[iLoop]);
            if (subDir.exists() || FileTool.createDirectory(directory + subdirectories[iLoop])) continue;
            success = false;
            break;
        }
        if (!success) {
            System.err.println("Directory [" + directory + "] creation failed !");
        }
        return success;
    }

    public static boolean move(String source, String destination) {
        try {
            return new File(source).renameTo(new File(destination));
        }
        catch (SecurityException e) {
            System.err.println("The file " + source + " could not moved to " + destination + " : " + e.getLocalizedMessage());
            return false;
        }
    }

    public static boolean copy(String source, String destination) {
        searchDepth = 0;
        return FileTool.filecopy(source, destination, true);
    }

    public static boolean copy(String source, String destination, boolean subdirectories) {
        searchDepth = 0;
        return FileTool.filecopy(source, destination, subdirectories);
    }

    protected static boolean filecopy(String source, String destination, boolean subdirectories) {
        boolean success;
        block13: {
            File sourceDir;
            String path;
            File dest;
            int bSlash;
            File sourceFile;
            block14: {
                success = true;
                sourceFile = new File(source);
                if (!sourceFile.isDirectory()) break block14;
                if (searchDepth++ > 0 && !subdirectories) {
                    return true;
                }
                if (!FileTool.fileExists(destination)) {
                    FileTool.createDirectories(destination);
                }
                String[] subFiles = sourceFile.list();
                for (int iLoop = 0; iLoop < subFiles.length; ++iLoop) {
                    FileTool.filecopy(source + File.separator + subFiles[iLoop], destination + File.separator + subFiles[iLoop], subdirectories);
                }
                break block13;
            }
            int fSlash = destination.lastIndexOf("/");
            int slash = fSlash > (bSlash = destination.lastIndexOf("\\")) ? fSlash : bSlash;
            if (slash > -1 && !(dest = new File(path = destination.substring(0, slash))).exists()) {
                FileTool.createDirectories(path);
            }
            File[] inputFiles = new File[]{sourceFile};
            String mask = sourceFile.getName();
            if (FileIncludes.isMask(mask) && null != (sourceDir = sourceFile.getParentFile()) && mask.length() > 0) {
                try {
                    FileIncludes filter = new FileIncludes(sourceDir, mask);
                    inputFiles = sourceDir.listFiles(filter);
                }
                catch (PatternSyntaxException e) {
                    // empty catch block
                }
            }
            File destFile = new File(destination);
            if (null == inputFiles) break block13;
            if (destFile.isFile() && inputFiles.length > 1) {
                System.err.println("For copying multiple files to the destination \"" + destination + "\" it must be a directory and NOT A SINGLE file.");
                success = false;
            } else {
                for (int idx = 0; idx < inputFiles.length; ++idx) {
                    File inputFile = inputFiles[idx];
                    File destinationFile = destFile.isDirectory() ? new File(destFile, inputFile.getName()) : destFile;
                    try {
                        Files.fileCopy(inputFile, destinationFile, true);
                        success = true;
                        continue;
                    }
                    catch (FileNotFoundException eFNF) {
                        System.err.println("The source file could not be found. " + eFNF);
                        System.err.println("Tried to copy " + inputFile + " to " + destinationFile + " : " + eFNF);
                        success = false;
                        break;
                    }
                    catch (IOException eIO) {
                        System.err.println("IOException occured while copying file.");
                        System.err.println("Tried to copy " + inputFile + " to " + destinationFile + " : " + eIO);
                        success = false;
                        break;
                    }
                }
            }
        }
        return success;
    }

    public static File getAbsoluteFile(String filename) {
        File file = new File(filename).getAbsoluteFile();
        if (".".equals(file.getName())) {
            file = file.getParentFile();
        } else if ("..".equals(file.getName()) && null != (file = file.getParentFile())) {
            file = file.getParentFile();
        }
        return file;
    }

    public static String makeDirectory(String aPath) {
        String path = aPath;
        String separatorChar = System.getProperty("file.separator");
        if (path != null && !path.endsWith(separatorChar)) {
            path = path + separatorChar;
        }
        return path;
    }

    public static boolean remove(String filename, boolean bRecursive) throws IOException {
        return FileTool.remove(filename, bRecursive, null);
    }

    public static boolean remove(String filename, boolean bRecursive, List<String> excludes) throws IOException {
        boolean bSuccess = true;
        if (filename != null && 0 != filename.length()) {
            File file = new File(filename);
            if (file.isDirectory()) {
                String[] files = file.list();
                if (!bRecursive && files.length > 0) {
                    System.err.println();
                    throw new IOException("Directory " + file.getAbsolutePath() + " is not Empty");
                }
                for (int iLoop = 0; iLoop < files.length; ++iLoop) {
                    String toRemove = FileTool.convertSlashes(file.getAbsolutePath() + "/" + files[iLoop]);
                    if (FileTool.isExcluded(toRemove, excludes) || FileTool.remove(toRemove, true)) continue;
                    bSuccess = false;
                }
                if (bSuccess && !FileTool.isExcluded(filename, excludes)) {
                    bSuccess = FileTool.remove(filename);
                }
            } else if (!FileTool.isExcluded(filename, excludes)) {
                bSuccess = FileTool.remove(filename);
            }
        }
        return bSuccess;
    }

    private static boolean isExcluded(String filename, List<String> excludes) {
        boolean bDelete = true;
        if (excludes != null && excludes.size() > 0) {
            for (int iFileLoop = 0; iFileLoop < excludes.size(); ++iFileLoop) {
                String exclude = FileTool.convertSlashes(excludes.get(iFileLoop));
                if (filename.indexOf(exclude) <= -1 && !exclude.startsWith(filename)) continue;
                bDelete = false;
                break;
            }
        }
        return !bDelete;
    }

    public static boolean remove(String filename) {
        try {
            return new File(filename).delete();
        }
        catch (SecurityException e) {
            System.err.println("The file " + filename + " could not be removed: " + e.getLocalizedMessage());
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readFileToList(String fileName) {
        ArrayList<String> list = new ArrayList<String>();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            System.err.println("The File " + fileName + " could not be found !!");
            e.printStackTrace();
            System.exit(3);
        }
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0 || line.trim().charAt(0) == '#') continue;
                list.add(line);
            }
        }
        catch (IOException e1) {
            System.err.println("IOException occured while reading " + fileName + "");
            e1.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFileToString(String fileName) {
        StringBuffer buffer = new StringBuffer();
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));
        }
        catch (FileNotFoundException e) {
            System.err.println("The File " + fileName + " could not be found !!");
            e.printStackTrace();
            System.exit(3);
        }
        String line = "";
        try {
            while ((line = br.readLine()) != null) {
                if (line.trim().length() <= 0 || line.trim().charAt(0) == '#') continue;
                buffer.append(line);
            }
        }
        catch (IOException e1) {
            System.err.println("IOException occured while reading " + fileName + "");
            e1.printStackTrace();
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return buffer.toString();
    }

    public static void writeStringToFile(String filename, String content) {
        File file = new File(filename);
        try {
            BufferedWriter bufWriter = new BufferedWriter(new FileWriter(file));
            bufWriter.write(content);
            bufWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String eliminateDoubleSlashes(String filename) {
        String result = "";
        result = filename.indexOf(":") == -1 && filename.startsWith("//") ? filename.substring(0, 2) + filename.substring(2).replaceAll("//", "/") : filename.replaceAll("//", "/");
        return result;
    }

    public static String convertSlashes(String path) {
        return path.replaceAll("\\\\", "/");
    }

    public static String convertBackSlashes(String path) {
        return path.replaceAll("/", "\\\\");
    }

    public static String convertBackSlashesNoParams(String aPath) {
        String path = aPath;
        int slash = -1;
        while ((slash = path.indexOf("/", slash + 1)) > -1) {
            if (slash <= -1 || path.charAt(slash - 1) == ' ') continue;
            String sLineStart = path.substring(0, slash);
            String sLineEnd = path.substring(slash + 1);
            path = sLineStart + "\\" + sLineEnd;
        }
        return path;
    }

    public static String normPath(String aPath) {
        if (!aPath.endsWith("/") && !aPath.endsWith("\\")) {
            return aPath + File.separator;
        }
        return aPath;
    }

    static class FileIncludes
    implements FilenameFilter {
        private File dir;
        private Pattern mask;
        private static String regexpSpecChars = ".\\$^()[]+";

        private static boolean isMask(String mask) {
            int pos = mask.indexOf(42);
            if (pos < 0) {
                pos = mask.indexOf(63);
            }
            return pos >= 0;
        }

        String toRegExp(String aMask) {
            StringBuffer sb = new StringBuffer();
            int length = aMask.length();
            for (int index = 0; index < length; ++index) {
                char ch = aMask.charAt(index);
                if (ch == '*') {
                    sb.append(".*");
                    continue;
                }
                if (ch == '?') {
                    sb.append(".+");
                    continue;
                }
                if (regexpSpecChars.indexOf(ch) >= 0) {
                    sb.append('\\').append(ch);
                    continue;
                }
                sb.append(ch);
            }
            return sb.toString();
        }

        public FileIncludes(File aDir, String aMask) {
            this.dir = aDir;
            this.mask = Pattern.compile(this.toRegExp(aMask));
        }

        @Override
        public boolean accept(File aDir, String name) {
            if (aDir.equals(this.dir)) {
                boolean matches = this.mask.matcher(name).matches();
                return matches;
            }
            return false;
        }
    }
}

