/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.NumberHelper;
import de.mcs.utils.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ExtendedProperties
extends Properties {
    public ExtendedProperties(File file) throws IOException {
        this.load(new FileInputStream(file));
    }

    public ExtendedProperties() {
    }

    public final boolean getBool(String key) {
        return Boolean.parseBoolean(this.getProperty(key));
    }

    public final boolean getBool(String key, boolean defaultValue) {
        return Boolean.parseBoolean(this.getProperty(key, Boolean.toString(defaultValue)));
    }

    public final int getInt(String key) {
        return NumberHelper.parseInt(this.getProperty(key));
    }

    public final int getInt(String key, int defaultValue) {
        return NumberHelper.parseInt(this.getProperty(key, Integer.toString(defaultValue)));
    }

    public final int getInt(String key, String defaultValue) {
        return NumberHelper.parseInt(this.getProperty(key, defaultValue));
    }

    public final long getLong(String key) {
        return Long.parseLong(this.getProperty(key));
    }

    public final long getLong(String key, long defaultValue) {
        return Long.parseLong(this.getProperty(key, Long.toString(defaultValue)));
    }

    public final File getFile(String key) {
        if (this.containsKey(key)) {
            return new File(this.getProperty(key));
        }
        return null;
    }

    public final File getFile(String key, File defaultValue) {
        return new File(this.getProperty(key, defaultValue.getAbsolutePath()));
    }

    public final String[] getStrings(String key) {
        String value = this.getProperty(key);
        if (value != null) {
            return StringUtils.csvStringToArray(value, ',', '\"');
        }
        return null;
    }

    public final String[] getStrings(String key, String[] defaultValue) {
        String value = this.getProperty(key);
        if (value != null) {
            return StringUtils.csvStringToArray(value, ',', '\"');
        }
        return defaultValue;
    }

    public final long getMSec(String key, String defaultValue) {
        return NumberHelper.parseTime(this.getProperty(key, defaultValue));
    }
}

