/*
 * Decompiled with CFR 0.152.
 */
package de.mcs.utils;

import de.mcs.utils.ConversionException;

public final class Conversions {
    private Conversions() {
    }

    public static int[] byteToInt(byte[] data) throws ConversionException {
        if (data.length % 4 > 0) {
            throw new ConversionException("array length doesn't match.");
        }
        int[] values = new int[data.length >> 2];
        int i = 0;
        for (int n : data) {
            int pos;
            int n2 = pos = i >> 2;
            values[n2] = values[n2] << 8;
            int aByte = n < 0 ? n + 256 : n;
            int n3 = pos;
            values[n3] = values[n3] | aByte;
            ++i;
        }
        return values;
    }

    public static float[] byteToFloat(byte[] data) throws ConversionException {
        throw new ConversionException("not implemented yet.");
    }

    public static short[] byteToShort(byte[] data) throws ConversionException {
        if (data.length % 2 > 0) {
            throw new ConversionException("array length doesn't match.");
        }
        short[] values = new short[data.length >> 1];
        int i = 0;
        for (int n : data) {
            int pos;
            int n2 = pos = i >> 1;
            values[n2] = (short)(values[n2] << 8);
            int aByte = n < 0 ? n + 256 : n;
            int n3 = pos;
            values[n3] = (short)(values[n3] | aByte);
            ++i;
        }
        return values;
    }

    public static long[] byteToLong(byte[] data) throws ConversionException {
        if (data.length % 8 > 0) {
            throw new ConversionException("array length doesn't match.");
        }
        long[] values = new long[data.length >> 3];
        int i = 0;
        for (int n : data) {
            int pos;
            int n2 = pos = i >> 3;
            values[n2] = values[n2] << 8;
            int aByte = n < 0 ? n + 256 : n;
            int n3 = pos;
            values[n3] = values[n3] | (long)aByte;
            ++i;
        }
        return values;
    }

    public static double[] byteToDouble(byte[] data) throws ConversionException {
        throw new ConversionException("not implemented yet.");
    }

    public static int[] byteToInt(int start, int len, byte[] data) throws ConversionException {
        byte[] datas = new byte[len];
        System.arraycopy(data, start, datas, 0, len);
        return Conversions.byteToInt(datas);
    }

    public static int byteToInt(byte[] data, int start) throws ConversionException {
        int[] ival = new int[1];
        ival = Conversions.byteToInt(start, 4, data);
        return ival[0];
    }

    public static short[] byteToShort(int start, int len, byte[] data) throws ConversionException {
        byte[] datas = new byte[len];
        System.arraycopy(data, start, datas, 0, len);
        return Conversions.byteToShort(datas);
    }

    public static short byteToShort(byte[] data, int start) throws ConversionException {
        short[] sval = new short[1];
        sval = Conversions.byteToShort(start, 2, data);
        return sval[0];
    }

    public static float[] byteToFloat(int start, int len, byte[] data) throws ConversionException {
        byte[] datas = new byte[len];
        System.arraycopy(data, start, datas, 0, len);
        return Conversions.byteToFloat(datas);
    }

    public static float byteToFloat(byte[] data, int start) throws ConversionException {
        float[] fval = new float[1];
        fval = Conversions.byteToFloat(start, 4, data);
        return fval[0];
    }

    public static long[] byteToLong(int start, int len, byte[] data) throws ConversionException {
        byte[] datas = new byte[len];
        System.arraycopy(data, start, datas, 0, len);
        return Conversions.byteToLong(datas);
    }

    public static long byteToLong(byte[] data, int start) throws ConversionException {
        long[] lval = new long[1];
        lval = Conversions.byteToLong(start, 8, data);
        return lval[0];
    }

    public static double[] byteToDouble(int start, int len, byte[] data) throws ConversionException {
        byte[] datas = new byte[len];
        System.arraycopy(data, start, datas, 0, len);
        return Conversions.byteToDouble(datas);
    }

    public static double byteToDouble(byte[] data, int start) throws ConversionException {
        double[] dval = new double[1];
        dval = Conversions.byteToDouble(start, 8, data);
        return dval[0];
    }

    public static byte[] intToByte(int start, int len, int[] data) throws ConversionException {
        int[] values = new int[len];
        byte[] result = new byte[len * 4];
        System.arraycopy(data, start, values, 0, len);
        for (int i = 0; i < values.length; ++i) {
            byte[] news = Conversions.intToByte(values[i]);
            System.arraycopy(news, 0, result, i * 4, news.length);
        }
        return result;
    }

    public static byte[] shortToByte(int start, int len, short[] data) throws ConversionException {
        short[] values = new short[len];
        byte[] result = new byte[len * 2];
        System.arraycopy(data, start, values, 0, len);
        for (int i = 0; i < values.length; ++i) {
            byte[] news = Conversions.shortToByte(values[i]);
            System.arraycopy(news, 0, result, i * 2, news.length);
        }
        return result;
    }

    public static byte[] floatToByte(int start, int len, float[] data) throws ConversionException {
        throw new ConversionException("not implemented yet.");
    }

    public static byte[] longToByte(int start, int len, long[] data) throws ConversionException {
        long[] values = new long[len];
        byte[] result = new byte[len * 8];
        System.arraycopy(data, start, values, 0, len);
        for (int i = 0; i < values.length; ++i) {
            byte[] news = Conversions.longToByte(values[i]);
            System.arraycopy(news, 0, result, i * 8, news.length);
        }
        return result;
    }

    public static byte[] doubleToByte(int start, int len, double[] data) throws ConversionException {
        throw new ConversionException("not implemented yet.");
    }

    public static byte[] byteToByte(byte data) {
        return new byte[]{data};
    }

    public static byte[] byteToByte(Byte data) {
        return Conversions.byteToByte((byte)data);
    }

    public static byte[] intToByte(int data) {
        byte[] value = new byte[]{(byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
        return value;
    }

    public static byte[] intToByte(Integer data) {
        return Conversions.intToByte((int)data);
    }

    public static byte[] shortToByte(short data) {
        byte[] value = new byte[]{(byte)(data >> 8), (byte)data};
        return value;
    }

    public static byte[] shortToByte(Short data) {
        return Conversions.shortToByte((short)data);
    }

    public static byte[] floatToByte(float data) {
        return null;
    }

    public static byte[] floatToByte(Float data) {
        return Conversions.floatToByte(data.floatValue());
    }

    public static byte[] longToByte(long data) {
        byte[] value = new byte[]{(byte)(data >> 56), (byte)(data >> 48), (byte)(data >> 40), (byte)(data >> 32), (byte)(data >> 24), (byte)(data >> 16), (byte)(data >> 8), (byte)data};
        return value;
    }

    public static byte[] longToByte(Long data) {
        return Conversions.longToByte((long)data);
    }

    public static byte[] doubleToByte(double data) {
        return null;
    }

    public static byte[] doubleToByte(Double data) {
        return Conversions.doubleToByte((double)data);
    }

    public static Object byteToNumber(byte[] barray, Object obj) throws ConversionException {
        Class<?> theClass = obj.getClass();
        String type = theClass.getName();
        Number retobj = null;
        if (type.equals("java.lang.Integer")) {
            int[] i = Conversions.byteToInt(0, 1, barray);
            retobj = new Integer(i[0]);
        } else if (type.equals("java.lang.Byte")) {
            retobj = new Byte(barray[0]);
        } else if (type.equals("java.lang.Short")) {
            short[] f = Conversions.byteToShort(0, 1, barray);
            retobj = new Short(f[0]);
        } else if (type.equals("java.lang.Float")) {
            float[] f = Conversions.byteToFloat(0, 1, barray);
            retobj = new Float(f[0]);
        } else if (type.equals("java.lang.Long")) {
            long[] f = Conversions.byteToLong(0, 1, barray);
            retobj = new Long(f[0]);
        } else if (type.equals("java.lang.Double")) {
            double[] f = Conversions.byteToDouble(0, 1, barray);
            retobj = new Double(f[0]);
        } else {
            ConversionException ex = new ConversionException("byteToNumber: setfield bad type: " + obj + " " + type);
            throw ex;
        }
        return retobj;
    }
}

