package de.mcs.utils.statistics;

/*
 * Count.java
 * Project: LEAF
 * WHEN WHO WHAT DESCRIPTION
 * BRY Creation
 * Copyright 2001 by ELCA Informatique SA
 * Av. de la Harpe 22-24, 1000 Lausanne 13
 * All rights reserved.
 * This software is the confidential and proprietary information
 * of ELCA Informatique SA. ("Confidential Information"). You
 * shall not disclose such Confidential Information and shall
 * use it only in accordance with the terms of the license
 * agreement you entered into with ELCA.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;

class ActionCount {

  int lines;

  int realComments;

  int realCode;

  int commentsToCode;

  String name;

  private static void assertCond(boolean cond, String msg) {
    if (!cond) {
      System.out.println("assertCond FAILED: " + msg);
      System.exit(1);
    }
    ;
  };

  static public String justify(int s) {
    return justify(s, 6);
  };

  static public String justify(int s, int i) {
    String b = "                                         ";
    String n = s + "";
    return b.substring(0, i - n.length()) + n;
  };

  public void prepare() {
  };

  public void done() {
  };

  public void exec(File dir, String filename) {
    boolean proceed = false;
    for (String type : Count.FILESTOCOUNT) {
      if (filename.endsWith(type))
        proceed = true;
    }
    if (!proceed || filename.equals("Count.java")) {
      return;
    }
    ;
    lines = 0;
    realComments = 0;
    realCode = 0;
    File filein = new File(dir, filename);
    name = filein.toString();
    convert(filein.toString());
    commentsToCode = (realCode == 0 ? 1000 : 100 * realComments / realCode);
    System.out.println("Lines:" + justify(lines) + " Cmt=" + justify(realComments) + " Code=" + justify(realCode)
        + " Ratio=" + justify(commentsToCode) + "% " + name);
    Count.lines += lines;
    Count.realComments += realComments;
    Count.realCode += realCode;
    Count.commentsToCode += commentsToCode;
    Count.fileCount++;
  };

  private void countLine(String line) {
    int pos;
    // javadoc
    if (line.indexOf("/**") > 0) {
      if (line.trim().length() > 3) {
        realComments++;
      }
      return;
    }

    if (line.indexOf("*") > 0) {
      if (line.trim().length() > 3) {
        realComments++;
        // System.out.println("##"+line) ;
        return;
      }
    }
    ;

    if ((line.trim().indexOf("/*") == 1) && (line.indexOf("*/") > 0)) {
      realComments++;
      // System.out.println("##"+line) ;
      return;
    }

    if (line.indexOf("*/") > 0)
      return;

    pos = line.indexOf("//");
    if (pos >= 0) {
      String t = line.substring(pos + 2).trim();
      if (t.length() > 0) {
        realComments++;
        // System.out.println("##"+line) ;
        return;
      }
      ;
    } else {
      String t = line.trim();
      if (t.length() > 3) {
        realCode++;
        // System.out.println("CC"+line) ;
        return;
      }
    }
    ;
    // System.out.println(" "+line) ;
  };

  public void convert(String filename) {
    FileInputStream inputStream = null;
    String line = null;
    try {
      inputStream = new FileInputStream(filename);
    } catch (Exception e) {
      assertCond(false, "File not readable " + filename);
    }
    ;

    BufferedReader file = new BufferedReader(new InputStreamReader(inputStream));

    while (true) {
      try {
        line = file.readLine();
        lines++;
      } catch (Exception e) {
        assertCond(false, "File not readable " + filename);
      }
      ;
      if (line == null) {
        break;
      }
      countLine(line);
    }
    ;

    try {
      file.close();
    } catch (Exception e) {
      assertCond(false, "File not closeable " + filename);
    }
    ;

  }; // convert

}; // end class ActionFormat

public class Count {
  public static int lines = 0;

  public static int realComments = 0;

  public static int realCode = 0;

  public static int fileCount = 0;

  public static int commentsToCode = 0;

  private static final String[] DIRECTORIES = { "./src", "./test/src", "./webroot" };

  protected static final String[] FILESTOCOUNT = { ".java", ".zul", ".vm" };

  static public String justify(int s) {
    return justify(s, 6);
  };

  static public String justify(int s, int i) {
    String b = "                                         ";
    String n = s + "";
    return b.substring(0, i - n.length()) + n;
  };

  private static void assertCond(boolean cond, String msg) {
    if (!cond) {
      System.out.println("assertCond FAILED: " + msg);
      System.exit(1);
    }
    ;
  };

  private static void reset() {
    lines = 0;
    realComments = 0;
    realCode = 0;
    fileCount = 0;
    commentsToCode = 0;
  }

  public static void main(String args[]) {
    ActionCount action = new ActionCount();
    action.prepare();

    for (String directory : DIRECTORIES) {
      reset();
      File d = new File(directory);
      System.out.println("-----------------------------");
      System.out.println("Counting Lines in all files " + d.getPath());
      System.out.println("-----------------------------");
      RecurseDir(action, d, 0);

      action.done();
      if (realCode > 0) {
        commentsToCode = 100 * realComments / realCode;
      }
      System.out.println("-----------------------------");
      System.out.println("Lines:" + justify(lines) + " Cmt=" + justify(realComments) + " Code=" + justify(realCode)
          + " Ratio=" + justify(commentsToCode) + "% " + " Total files=" + fileCount);
      System.out.println("-----------------------------");
    }

    action.prepare();

  }

  private static void RecurseDir(ActionCount action, java.io.File dir, int level) {
    assertCond(level < 100, "no infinite recursion");
    // File d = new File(dirName) ;
    String[] list = dir.list();
    int i;

    if (list != null) { // some io sanity check

      for (i = 0; i < list.length; i++) {
        action.exec(dir, list[i]);
        File f = new File(dir, list[i]);
        assertCond(f != null, "f is null");
        assertCond(list[i] != null, "list[i] is null");
        if (f.isDirectory() && (!list[i].equals("Backup"))) {
          RecurseDir(action, f, level + 1);
        }
      }
    }
  }

}
