/**
 * MCS Media Computer Software
 * Copyright 2012 by Wilfried Klaas
 * Project: MCSUtils
 * File: WatchDirThread.java
 * EMail: W.Klaas@gmx.de
 * Created: 23.02.2012 Willie
 */

package de.mcs.utils.nio;

import java.io.IOException;
import java.nio.file.Path;

/**
 * @author Willie
 * 
 */
public class WatchDirThread extends Thread {

  private Path watchDir;
  private WatchDir watcher;
  private WatchCallBack callback;
  private boolean enable;
  private boolean recursive;

  public WatchDirThread(WatchCallBack callback, Path watchDir, boolean recursive) throws IOException {
    this.watchDir = watchDir;
    this.callback = callback;
    this.recursive = recursive;
    this.setEnable(true);
    this.setDaemon(true);
  }

  /*
   * (non-Javadoc)
   * 
   * @see java.lang.Thread#run()
   */
  @Override
  public void run() {
    try {
      watcher = new WatchDir(watchDir, recursive);
      while (!isInterrupted()) {
        if (isEnable()) {
          watcher.processEvents(callback);
        } else {
          watcher.processEvents(new WatchCallBack() {
            @Override
            public void modified(Path path) {
              // Do nothing here
            }
          });
        }
        Thread.yield();
      }
      watcher.remove();
      watcher = null;
    } catch (IOException e) {
      e.printStackTrace();
    }
  }

  /**
   * @return the enable
   */
  public boolean isEnable() {
    return enable;
  }

  /**
   * @param enable
   *          the enable to set
   */
  public void setEnable(boolean enable) {
    this.enable = enable;
  }

}
