/**
 * MCS Media Computer Software
 * Copyright 2009 by Wilfried Klaas
 * Project: MCSUtils
 * File: CommandKey.java
 * EMail: W.Klaas@gmx.de
 * Created: 20.11.2009 Willie
 */

package de.mcs.utils.jsap;

/**
 * @author Willie
 */
public class CommandKey {
  private Character shortKey;

  private String longKey;

  private String name;

  private String help;

  private String defaultValue;

  private boolean required;

  public CommandKey(char shortKey, String longKey, String name, String help, String defaultValue) {
    this(shortKey, longKey, name, help);
    this.defaultValue = defaultValue;
  }

  public CommandKey(char shortKey, String longKey, String name, String help, boolean required) {
    this(shortKey, longKey, name, help);
    this.required = required;
  }

  public CommandKey(char shortKey, String longKey, String name, String help) {
    this.shortKey = shortKey;
    this.longKey = longKey;
    this.name = name;
    this.help = help;
    this.required = false;
  }

  public Character getShortKey() {
    return shortKey;
  }

  public String getLongKey() {
    return longKey;
  }

  public String getName() {
    return name;
  }

  public String getHelp() {
    return help;
  }

  /**
   * @return the defaultValue
   */
  public String getDefaultValue() {
    return defaultValue;
  }

  public boolean isRequired() {
    return required;
  }
}
